package com.pms.ocp.service;

import com.pms.ocp.model.dto.ModelDTO;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.vo.ResponseVO;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:03
 * @Description:模型业务层接口
 */
public interface ModelService {

    /**
     * 创建模型
     *
     * @param modelDTO
     * @return
     */
    Integer createModel(ModelDTO modelDTO);

    /**
     * 删除模型
     *
     * @param objId
     * @param modelCode
     * @return
     */
    Integer deleteModel(String objId, String modelCode);

    /**
     * 更新模型
     *
     * @param modelDTO
     * @return
     */
    Integer updateModel(ModelDTO modelDTO);

    /**
     * 导入模型
     *
     * @param file
     * @return
     */
    Boolean importModel(MultipartFile file) throws IOException;

    /**
     * 获取模型列表
     *
     * @param
     * @return
     */
    List<Model> getModelList(String objId, String modelCode, List<String> ownerCompanyCodes, List<String> modelGroupCodes);

    /**
     * 获取模型
     *
     * @param objId
     * @param modelCode
     * @return
     */
    Model getModel(String objId, String modelCode);

    /**
     * 获取模型列表
     *
     * @param belongLevel
     * @param modelCode
     * @param currentPage
     * @param pageSize
     * @param searchCondition
     * @return
     */
    ResponseVO getModeBaselList(String belongLevel, String modelCode, Integer currentPage, Integer pageSize, String searchCondition);
}
