package com.pms.ocp.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.*;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;

import java.sql.Timestamp;
import java.util.List;

/**
 * @author guofanfan
 */
public interface TenantBasicManagementService extends IService<OcpTenantBase> {
    /**
     * 条件查询
     * @param tenantCode
     * @param keyword
     * @param tenantUnit
     * @param startTime
     * @param endTime
     * @param pageSize
     * @param pageNum
     * @return
     */
    List<OcpTenantBaseDto> queryOcpTenantBaseDto(String tenantGroupCode,String tenantCode, String keyword, String tenantUnit, Timestamp startTime, Timestamp endTime, Integer pageSize, Integer pageNum);

    /**
     * 应用发布 改变其应用状态
     * @param tenantCodes 应用代码
     * @return
     */
    ResponseVO tenantIssue(String tenantCodes);

    /**
     * 应用订阅
     * @param tenantCodes
     */
    ResponseVO tenantLogin(String tenantCodes,String companyCode);

    /**
     * 下线
     * @param tenantCodes
     * @return
     */
    ResponseVO tenantCancel(String tenantCodes);

    /**
     * 应用注册
     * @param ocpTenantBaseDto
     */
    ResponseVO applyRegister(OcpTenantBaseDto ocpTenantBaseDto);

    /**
     * 应用树层级
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    List<GroupDto> tenantBaseTreeOther(String tenantGroupCode, String tenantGroupCompanyCode,String tenantCode);

    /**
     * 应用列表
     * @param tenantDto
     * @return
     */
    ResponseVO<PageInfo<OcpTenantBaseDto>> getBaseByGroupCode(TenantDto tenantDto);



    /**
     * 应用树底层
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    List<OcpTenantBase> tenantBaseTree(String tenantGroupCode, String tenantGroupCompanyCode);



    /**
     * 查询基础表
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    List<GroupDto> selectBase(String tenantGroupCode, String tenantGroupCompanyCode);

    /**
     * 省测-应用接入申请-编辑和添加应用服务关系
     * @param ocpBaseTiocnDto
     * @return
     */
    ResponseVO updateByCondition(OcpBaseTiocnDto ocpBaseTiocnDto);

    /**
     * 省测-应用接入申请-查询和应用关联的服务
     * @param tenantCode
     * @return
     */
    ResponseVO <List<OcpApiBase>>selectOcpByApi(String tenantCode);



    /**
     * 省测-应用接入申请-编辑和发布应用
     * @param ocpBaseTiocnDto
     * @return
     */
    ResponseVO saveAndUpdateTenant(OcpBaseTiocnDto ocpBaseTiocnDto);

    /**
     * 应用树
     * @param tenantGroupCode
     */

}
