package com.pms.ocp.service.impl;

import com.pms.ocp.mapper.ApiManagementMapper;
import com.pms.ocp.model.dto.ApiManagementDto;
import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.entity.OcpApiExtent;
import com.pms.ocp.model.vo.ApiManagementVO;
import com.pms.ocp.service.ApiManagementService;
import com.pms.ocp.service.OcpApiExtentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;

/**
 * @className: ApiManagementImpl
 * @Description:
 * @author: pei-chen-xi
 * @DateTime: 2022/3/25 14:32
 */
@Service
public class ApiManagementImpl implements ApiManagementService {

    @Autowired
    private ApiManagementMapper apiManagementMapper;
    @Autowired
    private OcpApiExtentService ocpApiExtentService;

    /**
     * @Description:服务管理查询
     * @param apiName,apiGroupCode,apiUrl,startTime,startTime,endTime,pageSize,pageNum
     * @return queryApiManagementList
     */

    @Override
    public List<ApiManagementVO> queryManagement(String apiName, String apiGroupCode, String apiUrl, Timestamp startTime,Timestamp endTime,Integer pageSize, Integer pageNum) {

        return apiManagementMapper.queryApiManagementList(apiName,apiGroupCode,apiUrl,startTime,endTime,pageSize,pageNum);
    }

    /**
     * @Description:服务管理新增
     * @param apiManagementDto
     * @return
     */
    @Override
    public void insertManagement(ApiManagementDto apiManagementDto) {
        apiManagementMapper.insert(apiManagementDto);
    }

    /**
     * @Description:服务管理修改
     * @param apiManagementDto
     * @return
     */
    @Override
    public void updateManagement(ApiManagementDto apiManagementDto) {
        apiManagementMapper.updateById(apiManagementDto);
    }

    /**
     * @Description:服务管理删除
     * @param ids
     * @return
     */
    @Override
    public void deleteManagement(Integer ids) {
        apiManagementMapper.deleteById(ids);
    }

    /**
     * @Description:导入数据
     * @param personList
     * @return
     */
    @Override
    public void apiImport(List<ApiManagementVO> personList) {
        for (ApiManagementVO apiManagementVO :personList){
            String apiName=apiManagementVO.getApiName();
            String apiCode=apiManagementVO.getApiCode();
            String apiGroupCode=apiManagementVO.getApiGroupCode();
            String apiDescription=apiManagementVO.getApiDescription();
            String ownerCompanyCode=apiManagementVO.getOwnerCompanyCode();
            String apiVersion=apiManagementVO.getApiVersion();
            String apiUrl=apiManagementVO.getApiUrl();
            Timestamp apiCtime = apiManagementVO.getApiCtime();

            OcpApiBase ocpApiBase = new OcpApiBase();
            ocpApiBase.setApiCode(apiCode);
            ocpApiBase.setApiGroupCode("1");
            ocpApiBase.setApiName(apiName);
            ocpApiBase.setApiDescription(apiDescription);
            ocpApiBase.setOwnerCompanyCode(ownerCompanyCode);
            ocpApiBase.setApiVersion(apiVersion);
            ocpApiBase.setApiUrl(apiUrl);
            ocpApiBase.setApiCtime(apiCtime);
            this.save(ocpApiBase);

            OcpApiExtent ocpApiExtent = new OcpApiExtent();
            ocpApiExtent.setApiCode(apiCode);
            ocpApiExtentService.save(ocpApiExtent);
        }
    }

    @Override
    public void save(OcpApiBase ocpApiBase) {

    }

    @Override
    public List<ApiManagementVO> selectApiExport(String apiCodes) {
        String[] split = apiCodes.split(",");
        List<String> list = Arrays.asList(split);
        return apiManagementMapper.selectApiExport(list);
    }


}
