package com.pms.ocp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.pms.ocp.mapper.MiddleGroundModelMapper;
import com.pms.ocp.model.entity.ModelPropInfo;
import com.pms.ocp.service.MiddleGroundModelService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/4/9 14:40
 */
@Service
//@DS("middleGround")
public class MiddleGroundModelServiceImpl implements MiddleGroundModelService {

    @Resource
    private MiddleGroundModelMapper middleGroundModelMapper;

    /**
     * 根据表名称查询中台表信息
     * @author huxiuwu
     * @date 2022/4/9
     * @param ModelName
     * @return pms.ocp.model.entity.ModelPropInfo
     **/
    @Override
    public ModelPropInfo selectMiddleGroundModeByName(String ModelName) {
        List<String> schemaNameList = middleGroundModelMapper.selectModels(ModelName);
        if (CollectionUtil.isEmpty(schemaNameList)){
            return new ModelPropInfo();
        }
        return middleGroundModelMapper.selectMiddleGroundModeByName(ModelName,schemaNameList.get(0));
    }

}
