package com.pms.ocp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.pms.ocp.mapper.ModelAcceptMapper;
import com.pms.ocp.mapper.ModelMapper;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelPropInfo;
import com.pms.ocp.model.entity.PropInfo;
import com.pms.ocp.model.vo.ModelAcceptListVo;
import com.pms.ocp.model.vo.ModelAcceptVo;
import com.pms.ocp.model.vo.ModelCheckVo;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.MiddleGroundModelService;
import com.pms.ocp.service.ModelAcceptService;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/4/7 16:13
 */
@Service
@Slf4j
public class ModelAcceptServiceImpl implements ModelAcceptService {

    @Resource
    private ModelAcceptMapper modelAcceptMapper;

    @Resource
    private MiddleGroundModelService middleGroundModelService;

    @Resource
    private ModelMapper modelMapper;

    /**
     * 模型验收列表
     * @author huxiuwu
     * @date 2022/4/7
     * @return pms.ocp.model.vo.ResponseVO
     **/
    @Override
    public ResponseVO modelAcceptList() {
        List<ModelAcceptListVo> list = modelAcceptMapper.modelAcceptList();
        return ResponseVO.ok(list);
    }

    /**
     * 模型验收详情
     * @author huxiuwu
     * @date 2022/4/8
     * @param modelCode 模型编码
     * @param requirementCode 需求编码
     * @return pms.ocp.model.vo.ResponseVO
     **/
    @Override
    public ResponseVO<ModelAcceptVo> modelAuditDetail(String modelCode, String requirementCode) {
        ModelAcceptVo vo = modelAcceptMapper.modelAuditDetail(requirementCode);
        //关联模型code
        List<ModelCheckVo> relationModel = modelAcceptMapper.relationModels(modelCode);
        vo.setRelationModels(relationModel);
        return ResponseVO.ok(vo);
    }

    /**
     * 模型信息对比
     * @author huxiuwu
     * @date 2022/4/11
     * @param requirementCode 需求编码
     * @param modelCode 模型编码
     * @param tableName 表名称
     * @return ResponseVO<java.util.List<com.pms.ocp.model.entity.ModelPropInfo>>
     **/
    @Override
    public ResponseVO<List<ModelPropInfo>> modelDetailCompare(String requirementCode,String modelCode,String tableName) {
        //查询中台库数据
        ModelPropInfo modelPropInfo = middleGroundModelService.selectMiddleGroundModeByName(tableName);
        //查询自己的属性
        List<PropInfo> propList = modelAcceptMapper.selectPropList(modelCode);
        //比较并封装
        List<ModelPropInfo> result = compareData(modelPropInfo ,propList,tableName);

        return ResponseVO.ok(result);
    }

    /**
     * @author huxiuwu
     * @date 2022/4/11
     * @param model 模型数据
     * @return ResponseVO<java.util.List<com.pms.ocp.model.entity.ModelPropInfo>>
     **/
    @SneakyThrows
    @Transactional(rollbackFor = Exception.class)
    @Override
    public ResponseVO<List<ModelPropInfo>> modelAcceptPass(Model model) {
        //新增至模型基础表
        int insert = modelMapper.insert(model);
        //删除模型版本表,属性版本表,需求表,审核表
        boolean modelVersion  = modelAcceptMapper.deleteModelVersion(model);
        boolean propVersion  =  modelAcceptMapper.deletePropVersion(model);
        boolean requireVersion  =  modelAcceptMapper.deleteRequirementVersion(model);
        boolean acceptVersion  =  modelAcceptMapper.deleteAcceptVersion(model);
        boolean modelRelationProp  =  modelAcceptMapper.deleteModelRelationProp(model);
        if ((modelVersion && modelRelationProp && propVersion && requireVersion && acceptVersion && insert!=0 )==false ){
            throw new Exception();
        }
        return ResponseVO.ok();
    }

    /**
     * 比较是否相似
     * @author huxiuwu
     * @date 2022/4/11
     * @param modelPropInfo
     * @param propList
     * @param tableName
     * @return List<com.pms.ocp.model.entity.ModelPropInfo>
     **/
    private List<ModelPropInfo> compareData(ModelPropInfo modelPropInfo, List<PropInfo> propList, String tableName) {
        List<ModelPropInfo> list = new LinkedList<>();
        ModelPropInfo owner = new ModelPropInfo();
        List<PropInfo> middleGroundList = modelPropInfo.getPropList();
        owner.setModelTable(tableName);
        if (CollectionUtil.isEmpty(middleGroundList)||CollectionUtil.isEmpty(propList)){
            owner.setPropList(propList);
            list.add(owner);
            list.add(modelPropInfo);
            return list;
        }
        List<PropInfo> ownerList = propList.stream().map(m -> {
            middleGroundList.stream().filter(m2-> Objects.equals(m.getPropName(),m2.getPropName())).forEach(m2->
                m.setSame(true)
            );
            return m;
        }).collect(Collectors.toList());
        owner.setPropList(ownerList);
        list.add(owner);
        list.add(modelPropInfo);
        return list;
    }

}
