package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.pms.ocp.mapper.ModelBaseVersionMapper;
import com.pms.ocp.model.entity.ModelBaseVersion;
import com.pms.ocp.service.ModelBaseVersionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/4/1 11:21
 * @Description:模型基础信息版本需求业务接口实现层
 */

@Service
public class ModelBaseVersionServiceImpl implements ModelBaseVersionService {

    @Autowired
    private ModelBaseVersionMapper modelBaseVersionMapper;

    @Override
    public Integer createModelBaseVersion(ModelBaseVersion modelBaseVersion) {

        return modelBaseVersionMapper.insert(modelBaseVersion);
    }

    @Override
    public Integer deleteModelBaseVersion(String requirementCode, String modelCode) {
        QueryWrapper<ModelBaseVersion> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(requirementCode)) {
            queryWrapper.lambda().eq(ModelBaseVersion::getRequirementCode, requirementCode);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelBaseVersion::getModelCode, modelCode);
        }

        return modelBaseVersionMapper.delete(queryWrapper);
    }

    @Override
    public Integer updateModelBaseVersion(ModelBaseVersion modelBaseVersion) {

//        UpdateWrapper<ModelBaseVersion> updateWrapper = new UpdateWrapper<>();
//
//        updateWrapper.lambda().eq(ModelBaseVersion::getModelCode, modelBaseVersion.getModelCode());


        LambdaUpdateWrapper<ModelBaseVersion> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
        lambdaUpdateWrapper.eq(ModelBaseVersion::getModelCode, modelBaseVersion.getModelCode()).
                eq(ModelBaseVersion::getRequirementCode, modelBaseVersion.getRequirementCode());


        return modelBaseVersionMapper.update(modelBaseVersion, lambdaUpdateWrapper);
    }

    @Override
    public List<ModelBaseVersion> getModelBaseVersionList(String modelCode, List<String> modelGroupCodeList, Integer currentPage, Integer pageSize) {

        QueryWrapper<ModelBaseVersion> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelBaseVersion::getModelCode, modelCode);
        }

        if (!modelGroupCodeList.isEmpty()) {
            queryWrapper.lambda().in(ModelBaseVersion::getModelGroupCode, modelGroupCodeList);
        }

        return modelBaseVersionMapper.selectList(queryWrapper);
    }

    @Override
    public ModelBaseVersion getModelBaseVersion(String modelTable, String modelCode, String modelName) {
        QueryWrapper<ModelBaseVersion> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(modelTable)) {
            queryWrapper.lambda().eq(ModelBaseVersion::getModelTable, modelTable);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelBaseVersion::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(modelName)) {
            queryWrapper.lambda().eq(ModelBaseVersion::getModelName, modelName);
        }

        return modelBaseVersionMapper.selectOne(queryWrapper);
    }
}
