package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.pms.ocp.mapper.ModelPropertyVersionMapper;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelPropertyVersion;
import com.pms.ocp.service.ModelPropertyVersionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/4/1 14:57
 * @Description:模型属性版本业务层接口实现
 */

@Service
public class ModelPropertyVersionServiceImpl implements ModelPropertyVersionService {

    @Autowired
    private ModelPropertyVersionMapper modelPropertyVersionMapper;

    @Override
    public Integer createModelPropertyVersion(ModelPropertyVersion modelPropertyVersion) {

        return modelPropertyVersionMapper.insert(modelPropertyVersion);
    }

    @Override
    public Integer deleteModelPropertyVersion(String requirementCode, String modelCode, String propCode) {
        QueryWrapper<ModelPropertyVersion> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(requirementCode)) {
            queryWrapper.lambda().eq(ModelPropertyVersion::getRequirementCode, requirementCode);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelPropertyVersion::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(propCode)) {
            queryWrapper.lambda().eq(ModelPropertyVersion::getPropCode, propCode);
        }

        return modelPropertyVersionMapper.delete(queryWrapper);
    }

    @Override
    public Integer updateModelPropertyVersion(ModelPropertyVersion modelPropertyVersion) {
        UpdateWrapper<ModelPropertyVersion> updateWrapper = new UpdateWrapper<>();

        updateWrapper.lambda().eq(ModelPropertyVersion::getPropCode, modelPropertyVersion.getPropCode());

        return modelPropertyVersionMapper.update(modelPropertyVersion, updateWrapper);
    }

    @Override
    public List<ModelPropertyVersion> getModelPropertyVersionList(String requirementCode, String modelCode) {
        QueryWrapper<ModelPropertyVersion> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(requirementCode)) {
            queryWrapper.lambda().eq(ModelPropertyVersion::getObjId, requirementCode);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelPropertyVersion::getModelCode, modelCode);
        }
        return modelPropertyVersionMapper.selectList(queryWrapper);
    }
}
