package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
//import com.pms.ocp.common.DataProcessUtil;
import com.pms.ocp.mapper.ModelMapper;
import com.pms.ocp.mapper.ModelPropertyMapper;
import com.pms.ocp.mapper.ModelRelationMapper;
import com.pms.ocp.model.dto.ModelRelationDTO;
import com.pms.ocp.model.entity.Model;
import com.pms.ocp.model.entity.ModelClassify;
import com.pms.ocp.model.entity.ModelProperty;
import com.pms.ocp.model.entity.ModelRelation;
import com.pms.ocp.model.vo.ModelRelationInputMultiVO;
import com.pms.ocp.model.vo.ModelRelationVO;
import com.pms.ocp.service.ModelRelationService;
import com.pms.ocp.service.OcpModelGroupService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Auther: wangjian
 * @Date: 2022/3/10 19:34
 * @Description:
 */

@Service
public class ModelRelationServiceImpl implements ModelRelationService {

    @Autowired
    private ModelRelationMapper modelRelationMapper;

    @Autowired
    private ModelMapper modelMapper;

    @Autowired
    private ModelPropertyMapper modelPropertyMapper;

    @Override
    public Integer createModelRelation(ModelRelationDTO modelRelationDTO) {

        ModelRelation modelRelation = new ModelRelation();

        BeanUtils.copyProperties(modelRelationDTO, modelRelation);

        modelRelation.setModelCtime(LocalDateTime.now());

        return modelRelationMapper.insert(modelRelation);
    }

    @Override
    public Integer deleteModelRelation(String objId, String modelCode) {

        QueryWrapper<ModelRelation> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelRelation::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelRelation::getModelCode, modelCode);
        }

        return modelRelationMapper.delete(queryWrapper);
    }

    @Override
    public Integer deleteBatchModelRelation(List<String> ids) {
        return modelRelationMapper.deleteBatchIds(ids);
    }

    @Override
    public Integer updateModelRelation(ModelRelation modelRelation) {
        return null;
    }

    @Autowired
    private OcpModelGroupService ocpModelGroupService;

    @Override
    public List<ModelRelationVO> getModelRelationList(String objId, String modelGroupCode, String modelCode) {


        QueryWrapper<ModelRelation> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(modelCode)) {

            if (StringUtils.isNotEmpty(modelCode)) {
                queryWrapper.lambda().eq(ModelRelation::getModelCode, modelCode);
            }

        } else {

            List<String> modelGroupCodeList = new ArrayList<>();

            QueryWrapper<ModelClassify> queryWrapper1 = new QueryWrapper();
            List<ModelClassify> modelClassifyList = ocpModelGroupService.list(queryWrapper1);

            getParentNode(modelGroupCodeList, modelClassifyList, modelGroupCode);
            modelGroupCodeList.add(modelGroupCode);


            QueryWrapper<Model> queryWrapper2 = new QueryWrapper();
            queryWrapper2.lambda().in(Model::getModelGroupCode, modelGroupCodeList);


            List<Model> modelList = modelMapper.selectList(queryWrapper2);

            List<String> modelCodeList = modelList.stream().map(Model::getModelCode).collect(Collectors.toList());


            if (!modelGroupCodeList.isEmpty()) {
                queryWrapper.lambda().in(ModelRelation::getModelCode, modelCodeList);
            }

        }


        List<ModelRelationVO> modelRelationVOList = new ArrayList<>();


        List<ModelRelation> modelRelationList = modelRelationMapper.selectList(queryWrapper);

        List<String> relationModelCodeList = modelRelationList.stream().map(ModelRelation::getRelationModeCode).collect(Collectors.toList());
        relationModelCodeList.add(modelCode);

        QueryWrapper<Model> queryWrapper4 = new QueryWrapper();
        queryWrapper4.lambda().in(Model::getModelCode, relationModelCodeList);


        List<Model> modelList1 = modelMapper.selectList(queryWrapper4);
        for (Model model : modelList1) {
            ModelRelationVO modelRelationVO = new ModelRelationVO();
            BeanUtils.copyProperties(model, modelRelationVO);
            modelRelationVOList.add(modelRelationVO);
        }

//        属性列表
        QueryWrapper<ModelProperty> queryWrapper3 = new QueryWrapper();
        queryWrapper3.lambda().in(ModelProperty::getModelCode, relationModelCodeList);

        List<ModelProperty> modelPropertyList = modelPropertyMapper.selectList(queryWrapper3);

        Map<String, List<ModelProperty>> map = modelPropertyList.stream().collect(Collectors.groupingBy(ModelProperty::getModelCode));
        Map<String, List<ModelRelation>> map1 = modelRelationList.stream().collect(Collectors.groupingBy(ModelRelation::getRelationModeCode));


        for (ModelRelationVO modelRelationVO : modelRelationVOList) {
            String modelCode1 = modelRelationVO.getModelCode();

            List<ModelRelation> modelRelationList1 = map1.get(modelCode1);

            if (modelRelationList1 == null) {
                continue;
            }

            modelRelationVO.setModelPropCode(modelRelationList1.get(0).getRelationModeCode());
            modelRelationVO.setRelationModeCode(modelRelationList1.get(0).getModelCode());
            modelRelationVO.setRelationModePropCode(modelRelationList1.get(0).getModelPropCode());


            modelRelationVO.setModelPropertyList(map.get(modelCode1));


        }


        return modelRelationVOList;

    }

    /**
     * 递归获取某个父节点下面的所有子节点
     *
     * @param childMenu       要返回的结果
     * @param menuList        数据库查询出来的所有集合
     * @param modelGroupPcode 父类编码
     */
    private static void getParentNode(List<String> childMenu, List<ModelClassify> menuList, String modelGroupPcode) {
        menuList.stream()
                //过滤出父id等于参数的id
                .filter(menu -> StringUtils.isNotBlank(menu.getModelGroupPcode()) && menu.getModelGroupPcode().equals(modelGroupPcode))
                .forEach(menu -> {
                    //递归遍历下一级
                    getParentNode(childMenu, menuList, menu.getModelGroupCode());
                    //添加
                    childMenu.add(menu.getModelGroupCode());
                });
    }


    @Override
    public ModelRelationVO getModelRelation(String modelId) {
        return null;
    }

//    @Resource
//    private DataProcessUtil dataProcessUtil;
//
//    @Override
//    public ModelRelation buildRegionTreeByRegionId(String regionId) {
//        return dataProcessUtil.recursiveTree(modelRelationMapper, regionId);
//    }
//
//    @Override
//    public List<ModelRelation> buildMultiRegionTreeByRegionIdList(ModelRelationInputMultiVO regionInputMultiVO) {
//        return dataProcessUtil.recursiveTreeList(modelRelationMapper, regionInputMultiVO);
//    }
}
