package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.pms.ocp.mapper.ModelRequirementApprovalMapper;
import com.pms.ocp.model.entity.ModelRequirement;
import com.pms.ocp.model.entity.ModelRequirementApproval;
import com.pms.ocp.model.vo.ModelVersionRequirementVO;
import com.pms.ocp.service.ModelRequirementApprovalService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/4/7 20:05
 * @Description:模型需求审批业务层接口实现
 */

@Service
public class ModelRequirementApprovalServiceImpl implements ModelRequirementApprovalService {

    @Autowired
    private ModelRequirementApprovalMapper modelRequirementApprovalMapper;

    @Override
    public Integer createModelRequirementApproval(ModelRequirementApproval modelRequirementApproval) {
        return modelRequirementApprovalMapper.insert(modelRequirementApproval);
    }

    @Override
    public Integer deleteModelRequirementApproval(String objId, String requirementCode) {

        QueryWrapper<ModelRequirementApproval> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelRequirementApproval::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(requirementCode)) {
            queryWrapper.lambda().eq(ModelRequirementApproval::getRequirementCode, requirementCode);
        }
        
        return modelRequirementApprovalMapper.delete(queryWrapper);
    }

    @Override
    public Integer updateModelRequirementApproval(ModelRequirementApproval modelRequirementApproval) {
        UpdateWrapper<ModelRequirementApproval> updateWrapper = new UpdateWrapper<>();

        updateWrapper.lambda().eq(ModelRequirementApproval::getRequirementCode, modelRequirementApproval.getRequirementCode());

        return modelRequirementApprovalMapper.update(modelRequirementApproval, updateWrapper);
    }

    @Override
    public List<ModelVersionRequirementVO> getModelRequirementApprovalList(String modelName, String modelCode, List<String> modelGroupCodes) {
        return null;
    }

    @Override
    public ModelRequirement getModelRequirementApproval(String objId, String modelCode) {
        return null;
    }
}
