package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.pms.ocp.mapper.ModelRequirementMapper;
import com.pms.ocp.model.dto.ModelVersionRequirementDTO;
import com.pms.ocp.model.entity.ModelRequirement;
import com.pms.ocp.model.vo.ModelPropertyVersionRequirementVO;
import com.pms.ocp.model.vo.ModelVersionRequirementVO;
import com.pms.ocp.service.ModelRequirementService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/3/29 17:43
 * @Description:模型需求业务层接口实现
 */

@Service
public class ModelRequirementServiceImpl implements ModelRequirementService {

    @Autowired
    private ModelRequirementMapper modelRequirementMapper;

    @Override
    public Integer createModelRequirement(ModelRequirement modelRequirement) {
        return modelRequirementMapper.insert(modelRequirement);
    }

    @Override
    public Integer deleteModelRequirement(String objId, String requirementCode) {
        QueryWrapper<ModelRequirement> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelRequirement::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(requirementCode)) {
            queryWrapper.lambda().eq(ModelRequirement::getRequirementCode, requirementCode);
        }

        return modelRequirementMapper.delete(queryWrapper);
    }

    @Override
    public Integer updateModelRequirement(ModelRequirement modelRequirement) {
        UpdateWrapper<ModelRequirement> updateWrapper = new UpdateWrapper<>();

        updateWrapper.lambda().eq(ModelRequirement::getRequirementCode, modelRequirement.getRequirementCode());

        return modelRequirementMapper.update(modelRequirement, updateWrapper);
    }

    @Override
    public List<ModelVersionRequirementVO> getModelRequirementList(String modelName, String modelCode, List<String> modelGroupCodes) {

//        QueryWrapper<ModelRequirement> wrapper = new QueryWrapper<>();
//
//        if (!requirementCodes.isEmpty()) {
//            wrapper.lambda().in(ModelRequirement::getRequirementCode, requirementCodes);
//        }

        return modelRequirementMapper.listModelRequirementVO(modelName, modelCode, modelGroupCodes);
    }

    @Override
    public List<ModelPropertyVersionRequirementVO> getModelPropertyRequirementList(String requirementCode, String modelCode, String columnName) {
        return modelRequirementMapper.listModelPropertyVersionRequirementVO(requirementCode, modelCode, columnName);
    }

    @Override
    public ModelRequirement getModelRequirement(String objId, String modelCode) {
        return null;
    }
}
