package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.common.constants.Constant;
import com.pms.ocp.common.utils.TreeUtils;
import com.pms.ocp.mapper.ModelSubscribeMapper;
import com.pms.ocp.model.dto.ModelSubscribeDTO;
import com.pms.ocp.model.entity.ModelSubscribe;
import com.pms.ocp.model.entity.TreeNode;
import com.pms.ocp.model.vo.ModelListNavigationVO;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelSubscribeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:22
 * @Description:模型订阅业务层实现
 */

@Service
public class ModelSubscribeServiceImpl implements ModelSubscribeService {

    @Resource
    private ModelSubscribeMapper modelSubscribeMapper;

    @Override
    public Integer createModelSubscribe(ModelSubscribeDTO modelSubscribeDTO) {

        ModelSubscribe modelSubscribe = new ModelSubscribe();

        BeanUtils.copyProperties(modelSubscribeDTO, modelSubscribe);

        modelSubscribe.setSubsCtime(LocalDateTime.now());

        return modelSubscribeMapper.insert(modelSubscribe);
    }

    @Override
    public Integer deleteModelSubscribe(String modelId) {
        return null;
    }

    /**
     * 批量删除模型订阅
     *
     * @param ids
     * @return
     */
    @Override
    public Integer deleteBatchModelSubscribe(List<String> ids) {
        return modelSubscribeMapper.deleteBatchIds(ids);
    }

    @Override
    public Integer updateModelSubscribe(ModelSubscribe modelSubscribe) {
        return null;
    }

    @Override
    public List<ModelSubscribe> getModelSubscribeList(String objId, String modelCode, String subsCompanyCode) {
        QueryWrapper<ModelSubscribe> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelSubscribe::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelSubscribe::getModelCode, modelCode);
        }

        if (StringUtils.isNotEmpty(subsCompanyCode)) {
            queryWrapper.lambda().eq(ModelSubscribe::getSubsCompanyCode, subsCompanyCode);
        }

        return modelSubscribeMapper.selectList(queryWrapper);
    }

    /**
     * 服务列表导航树
     * @author huxiuwu
     * @date 2022/3/11
     *
     * @return pms.ocp.model.vo.ResponseVO
     **/
    @Override
    public ResponseVO modelListNavigation(String searchCondition) {
        ModelListNavigationVO<TreeNode> modelNavigationVO = new ModelListNavigationVO<>();
        //查询模型和模型属性表列表
        List<TreeNode> modelGroupList =  modelSubscribeMapper.selectModelAndModelGroup();
        List<TreeNode> modelList = modelSubscribeMapper.getModelList(searchCondition);
        //统推自建分组
        Map<Integer,List<TreeNode>> modelGroupMap = modelList.stream().collect(Collectors.groupingBy(TreeNode::getModelPromotion));
        //统推list
        List<TreeNode> unifiedPushList = setChildren(HandlingNullPointers(modelGroupMap.get(Constant.Number.ZERO)),modelGroupList ,(org, group) ->
                org.getModelGroupCode().equals(group.getModelGroupCode()));
        List<TreeNode> newModelGroupList = TreeUtils.build(unifiedPushList);
        modelNavigationVO.setUnifiedPush(newModelGroupList);
        List<TreeNode> selfModelBuildList = setChildren(HandlingNullPointers(modelGroupMap.get(Constant.Number.ONE)),modelGroupList ,(org, group) ->
                org.getModelGroupCode().equals(group.getModelGroupCode()));
        //查询组织机构表
        List<TreeNode> organList = modelSubscribeMapper.selectOrganData();
        //将分类放入各自所属于的组织机构下
        List<TreeNode> groupOrgList = setChildren(selfModelBuildList, organList,(org, group) ->
                org.getCompanyCode().equals(group.getCompanyCode())
        );
        List<TreeNode> selfBuildList = TreeUtils.build(groupOrgList);
        modelNavigationVO.setSelfBuilt(selfBuildList);
        return ResponseVO.ok(modelNavigationVO);
    }
    /**
     * 处理空指针问题
     * @author huxiuwu
     * @date 2022/4/6
     * @param list
     * @return List<com.pms.ocp.model.entity.TreeNode>
     **/
    private List<TreeNode> HandlingNullPointers(List<TreeNode> list){
        return list == null ? new LinkedList<>() : list;
    }
    /**
     * 合并list设置子类
     * @param modelGroupList
     * @param organList
     * @param function
     * @return
     */
    private List<TreeNode> setChildren(List<TreeNode> modelGroupList, List<TreeNode> organList, BiFunction<TreeNode,TreeNode,Boolean> function) {
        organList.forEach(org -> {
            modelGroupList.forEach(group -> {
                if (function.apply(org, group) ) {
                    if (org.getChildren() == null) {
                        org.setChildren(new LinkedList<>());
                    }
                    org.getChildren().add(group);
                }
            });
        });
        return organList;
    }
}
