package com.pms.ocp.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.OcpTenantBaseMapper;
import com.pms.ocp.mapper.TenantBasicManagementMapper;
import com.pms.ocp.mapper.TenantMapper;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.service.TenantService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.*;


/**
 * @author zhaochengming
 */
@Service
public class TenantServiceImpl extends ServiceImpl<TenantMapper, OcpTenantGroup> implements TenantService {


    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TenantBasicManagementMapper tenantBasicMapper;


    @Autowired
    private OcpTenantBaseMapper ocpTenantBaseMapper;

    /**
     * 应用树分类管理
     *
     * @return
     */
    @Override
    public List<OcpTenantGroup> getTree(String tenantGroupCompanyCode, String tenantGroupCode, String level) {
        List<OcpTenantGroup> ocpTenantGroupList = null;
        if (StringUtils.isBlank(level)) {
            //顶级目录
            ocpTenantGroupList = tenantMapper.oneTenantGroup();
        } else if (StringUtils.isNotBlank(level) && "1".equals(level)) {
            //二级目录
            ocpTenantGroupList = tenantMapper.selectGroups(tenantGroupCompanyCode);
        } else if (StringUtils.isNotBlank(level) && "2".equals(level) || "3".equals(level)) {
            //三级目录
            ocpTenantGroupList = tenantMapper.selectTenantGroups(tenantGroupCode, tenantGroupCompanyCode);


        }
        return ocpTenantGroupList;
    }

    /**
     * 应用新增
     *
     * @param
     * @return
     */
    @Override
    public OcpTenantGroup getTenanInster(TenanBaseDto tenanBaseDto) {
        OcpTenantGroup group = new OcpTenantGroup();
        boolean falg = true;
        if (StringUtils.isNotBlank(tenanBaseDto.getTenantGroupCode())) {
            List<OcpTenantBase> ocpTenantBases = ocpTenantBaseMapper.selcctCodeList(tenanBaseDto.getTenantGroupCode());
            if (ocpTenantBases.size() > 0) {
                group.setNum("1");
                falg = false;
            }
        }
        if (falg) {
            String randomString = RandomStringUtils.getRandomString(6);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            BeanUtils.copyProperties(tenanBaseDto, group);
            group.setTenantGroupPcode(tenanBaseDto.getTenantGroupCode());
            group.setTenantType("应用");
            group.setTenantGroupVersion("1.0");
            group.setTenantGroupCode(randomString);
            group.setTenantGroupOrderNo(1);
            group.setTenantGroupCtime(timestamp);
            group.setTenantGroupMtime(timestamp);
            group.setTenantGroupVersion("1.0");
            group.setTenantGroupCode(randomString);

            if ("Middleground".equals(tenanBaseDto.getTenantGroupLevel())) {
                group.setTenantGroupLevel("sys_center");
            } else if ("sys_center".equals(tenanBaseDto.getTenantGroupLevel())) {
                group.setTenantGroupLevel("api_group");
            } else if (StringUtils.isBlank(tenanBaseDto.getTenantGroupLevel())) {
                group.setTenantGroupLevel("Middleground");
            }
            if (StringUtils.isNotBlank(tenanBaseDto.getTenantGroupCode())) {
                OcpTenantGroup ocpTenantGroup = tenantMapper.selectGroupCode(tenanBaseDto.getTenantGroupCode());
                String tenantGroupName = ocpTenantGroup.getTenantGroupName();
                group.setClassIfy(tenantGroupName);
            }

            tenanBaseDto.setIsDelete((short) 0);


        }
        String tenantGroupCompanyCode = tenanBaseDto.getTenantGroupName();
        //判断是否含有相同的分类名称
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
        if (falg) {
            for (OcpTenantGroup ocpTenantGroup : ocpTenantGroupList) {
                String tenantGroupCompanyCode1 = ocpTenantGroup.getTenantGroupName();
                if (tenantGroupCompanyCode.equals(tenantGroupCompanyCode1)) {
                    falg = false;
                    group.setNum("1");
                }
            }
        }


        if (falg) {
            tenanBaseDto.setClassIfy(tenanBaseDto.getTenantGroupCode());
            tenantMapper.insert(group);
        }


        return group;


    }

    /**
     * 修改应用
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean getTenantUpdata(OcpTenantGroup ocpTenantGroup) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        boolean falg = true;
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
        for (OcpTenantGroup ocpApiGroup : ocpTenantGroupList) {
            String name = ocpTenantGroup.getTenantGroupName();
            if (name.equals(ocpApiGroup.getTenantGroupName())) {
                falg = false;
                break;
            }
        }
        if (falg) {
            OcpTenantGroup ocpTenantGroup1 = new OcpTenantGroup();
            ocpTenantGroup1.setTenantGroupMtime(timestamp);
            tenantMapper.updateById(ocpTenantGroup);
        }

        return falg;
    }

    /**
     * 删除服务
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean gettenantDelete(OcpTenantGroup ocpTenantGroup) {
        String objId = ocpTenantGroup.getObjId();
        OcpTenantGroup ocpTenantGroup1 = tenantMapper.selectById(objId);
        boolean flag = true;
        List<OcpTenantGroup> group = new ArrayList<>();
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
        for (OcpTenantGroup tenantGroup : ocpTenantGroupList) {
            if (tenantGroup.getTenantGroupPcode().equals(ocpTenantGroup1.getTenantGroupCode())) {
                group.add(tenantGroup);
            }
        }
        if (group.size() >= 1) {
            flag = false;
        } else {
            tenantMapper.deleteById(objId);
        }
        return flag;
    }

    /**
     * 应用--查询
     *
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    @Override
    public Page<OcpTenantGroup> getselects(String tenantGroupCode, String tenantGroupCompanyCode, int currentPage, int pageSize, String keyword, String lev) {
        LambdaQueryWrapper<OcpTenantGroup> qw = new LambdaQueryWrapper<>();
        OcpTenantGroup ocpTenantGroup = tenantMapper.selectGroupCode(tenantGroupCode);

        Page<OcpTenantGroup> page = new Page<>(currentPage, pageSize);

        if (StringUtils.isBlank(keyword)) {
            if (StringUtils.isBlank(lev) || "1".equals(lev)) {
                LambdaQueryWrapper<OcpTenantGroup> eq = qw.eq(OcpTenantGroup::getTenantGroupCompanyCode, tenantGroupCompanyCode).orderByDesc(OcpTenantGroup::getTenantGroupMtime);
                tenantMapper.selectPage(page, eq);
            } else if ("2".equals(lev) || "3".equals(lev)) {
                LambdaQueryWrapper<OcpTenantGroup> eq = qw.or(wq -> wq.eq(OcpTenantGroup::getTenantGroupCompanyCode, tenantGroupCompanyCode))
                        .eq(OcpTenantGroup::getTenantGroupPcode, tenantGroupCode).orderByDesc(OcpTenantGroup::getTenantGroupMtime);
                tenantMapper.selectPage(page, eq);
            }
        } else if (!(StringUtils.isBlank(keyword))) {
            LambdaQueryWrapper<OcpTenantGroup> ocpTenantGroupLambdaQueryWrapper = qw.and(c -> c.like(OcpTenantGroup::getTenantGroupCompanyCode, keyword))
                    .or().like(OcpTenantGroup::getTenantGroupName, keyword)
                    .orderByDesc(OcpTenantGroup::getTenantGroupMtime);

            tenantMapper.selectPage(page, ocpTenantGroupLambdaQueryWrapper);
//            OcpTenantGroup ocpTenantGroup1 = new OcpTenantGroup();
//            ocpTenantGroup1.setKeyword(keyword);
//            List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectLikeList(ocpTenantGroup1);
//            page.setRecords(ocpTenantGroupList);
//            page.setTotal(ocpTenantGroupList.size());
        }
        if (StringUtils.isBlank(page.toString())) {
            List<OcpTenantGroup> records = page.getRecords();
            for (OcpTenantGroup record : records) {
                String tenantGroupCode1 = record.getTenantGroupName();
                OcpTenantGroup ocpTenantGroup1 = tenantMapper.selectGroupName(tenantGroupCode1);
                record.setClassIfy(ocpTenantGroup1.getTenantGroupName());
            }
        }
        if (StringUtils.isBlank(tenantGroupCode)) {
            List<OcpTenantGroup> records = page.getRecords();
            for (OcpTenantGroup record : records) {
                record.setClassIfy(record.getTenantGroupName());
            }
        }

        if (StringUtils.isNotBlank(tenantGroupCode)) {
            OcpTenantGroup ocpTenantGroup1 = tenantMapper.selectGroupName(tenantGroupCode);
            String tenantGroupName = ocpTenantGroup1.getTenantGroupName();
            List<OcpTenantGroup> records = page.getRecords();
            for (OcpTenantGroup record : records) {
                record.setClassIfy(tenantGroupName);
            }
        }

        return page;

    }
}





