package com.pms.ocp.controller;

import com.pms.ocp.common.constants.ResultCode;
import com.pms.ocp.model.entity.ModelClassify;
import com.pms.ocp.model.vo.OcpModelGroupVO;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelClassifyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author huxiuwu
 * @version 1.0
 * @date 2022/3/8 15:08
 */
@Slf4j
@RequestMapping("/modelClassify")
@RestController
@Api(tags = "模型分类")
public class ModelClassifyController {

    @Autowired
    private ModelClassifyService modelClassifyService;

    /**
     * 模型分类导航
     * @return pms.ocp.model.vo.ResponseVO
     * @author huxiuwu
     * @date 2022/3/9
     **/
    @ApiOperation("模型分类导航")
    @GetMapping("/navigation")
    public ResponseVO<List<OcpModelGroupVO>> getModelNavigation() {
        return modelClassifyService.getModelNavigation();
    }

    /**
     * 右侧子类详情列表
     *
     * @return pms.ocp.model.vo.ResponseVO
     * @author huxiuwu
     * @date 2022/3/9
     **/
    @ApiOperation("右侧子类详情列表")
    @GetMapping("/subclassDetailsList")
    public ResponseVO subclassDetailsList(@RequestParam int currentPage,
                                                                     @RequestParam int pageSize,
                                                                     @RequestParam(required = false,defaultValue = "") String parentGroupCode,
                                                                     @RequestParam(required = false,defaultValue = "") String subclassGroupName
    ) {
        return modelClassifyService.subclassDetailsList(currentPage, pageSize, parentGroupCode, subclassGroupName);
    }

    /**
     * 新增
     *
     * @param list 新增分类列表
     * @return pms.ocp.model.vo.ResponseVO
     * @author huxiuwu
     * @date 2022/3/9
     **/
    @ApiOperation("新增")
    @PostMapping("/insert")
    public ResponseVO insert(@RequestBody List<ModelClassify> list) {
        return modelClassifyService.insert(list);
    }

    /**
     * 修改
     *
     * @param list 修改list
     * @return pms.ocp.model.vo.ResponseVO
     * @author huxiuwu
     * @date 2022/3/9
     **/
    @ApiOperation("修改")
    @PostMapping("/update")
    public ResponseVO update(@RequestBody List<ModelClassify> list) {
        return modelClassifyService.update(list);
    }

    /**
     * 删除模型分类
     **/
    @ApiOperation("删除模型分类")
    @PostMapping("/delete")
    public ResponseVO delete(@RequestBody ModelClassify modelClassify) {

        Integer integer = modelClassifyService.deleteModelClassify(modelClassify.getObjId(), modelClassify.getModelGroupCode(), modelClassify.getGroupCompanyCode());
        if (integer.intValue() == -1) {
            ResponseVO.ok(ResultCode.NO_DELETE);
        }
        return ResponseVO.ok(integer);
    }

    /**
     * 删除
     *
     * @return pms.ocp.model.vo.ResponseVO
     * @author huxiuwu
     * @date 2022/3/9
     **/
    @ApiOperation("删除")
    @GetMapping("/delete")
    public ResponseVO delete(String modelGroupCode) {
        return modelClassifyService.delete(modelGroupCode);
    }
}
