package com.pms.ocp.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.sql.Date;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:40
 * @Description:模型属性DTO对象
 */

@ApiModel(value = "模型属性DTO对象")
@Data
public class ModelPropertyDTO {

    /**
     * 模型属性编号
     */
    @ApiModelProperty(value = "模型属性编号")
    private String objId;

    /**
     * 模型编号
     */
    @ApiModelProperty(value = "模型编号")
    private String modelCode;

    /**
     * 模型名称
     */
    @ApiModelProperty(value = "模型名称")
    private String modelName;

    /**
     * 属性名称
     */
    @ApiModelProperty(value = "属性名称")
    private String columnName;

    /**
     * 属性编码
     */
    @ApiModelProperty(value = "属性编码")
    private String propCode;

    /**
     * 属性描述
     */
    @ApiModelProperty(value = "属性描述")
    private String columnComments;

    /**
     * 数据类型
     */
    @ApiModelProperty(value = "数据类型")
    private String dataType;

    /**
     * 数据长度
     */
    @ApiModelProperty(value = "数据长度")
    private Integer dataLength;

    /**
     * 数据精度
     */
    @ApiModelProperty(value = "数据精度")
    private Integer dataScale;

    /**
     * 是否主键 0:否,1:是
     */
    @ApiModelProperty(value = "是否主键 0:否,1:是")
    private Integer boolPrimaryKey;

    /**
     * 是否必填 0:否,1:是
     */
    @ApiModelProperty(value = "是否必填 0:否,1:是")
    private Integer boolRequired;

    /**
     * 表名称
     */
//    @ApiModelProperty(value = "表名称")
//    private String modelTableName;

    /**
     * 显示顺序
     */
    @ApiModelProperty(value = "显示顺序")
    private Integer propOrderNo;

    /**
     * 提交人编号
     */
    @ApiModelProperty(value = "提交人编号")
    private String propUserId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty(value = "提交人姓名")
    private String propUserName;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private Date propCtime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "修改时间")
    private Date propMtime;

}

//    字段名称	字段描述	字段类型	允许为NULL	备注
//        prop_id	主键	varchar(42)	否
//        model_id	模型id	varchar(42)	否
//        column_name	属性名称	varchar(50)	否
//        column_code	属性编码	varchar(42)	否
//        column_comments	属性描述	varchar(50)	否
//        data_type	数据类型	int4	否
//        data_length	数据长度	int4	是
//        data_scale	数据精度	int4	是
//        is_pk	是否主键	int4	否	0:否,1:是
//        is_required	是否必填	int4	是	0:否,1:是
//        prop_promotion	推广类型	int4	是	0:统推,1：自建
//        company_id	省公司ID	varchar(42)	是
//        company_name	省公司名称	varchar(50)	是
//        prop _dispidx	显示顺序	int4	否
//        prop_user_id	提交人id	varchar(42)	否
//        prop_user_name	提交人姓名	varchar(64)	否
//        prop_ctime	创建时间	timestamp(6)	否
//        prop_mtime	修改时间	timestamp(6)	否
