package com.pms.ocp.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/3/10 16:35
 * @Description:模型订阅DTO对象
 */

@ApiModel(value = "模型订阅DTO对象")
@Data
public class ModelSubscribeDTO {

    /**
     * 模型属性编号
     */
    @ApiModelProperty(value = "模型属性编号")
    private String objId;

    /**
     * 模型编号
     */
    @ApiModelProperty(value = "模型编号")
    private String modelCode;

    /**
     * 订阅状态 0:订阅, 1:取消订阅
     */
    @ApiModelProperty(value = "订阅状态 0:订阅, 1:取消订阅")
    private String subsStatus;

    /**
     * 订阅公司编码
     */
    @ApiModelProperty(value = "订阅公司编码")
    private String subsCompanyCode;

    /**
     * 订阅人员编号
     */
    @ApiModelProperty(value = "订阅人员编号")
    private String subsUserId;

    /**
     * 订阅人名称
     */
    @ApiModelProperty(value = "订阅人名称")
    private String subsUserName;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime subsCtime;

    /**
     * 修改时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime subsMtime;

}
