package com.pms.ocp.model.dto;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.pms.ocp.model.entity.OcpTenantGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.sql.Timestamp;

/**
 * 新增应用封装对象
 */
@ApiModel(value = "新增应用封装对象")
@Data
@EqualsAndHashCode(callSuper=false)
public class TenanBaseDto extends OcpTenantGroup {


    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    /**
     * 应用分类编码
     */
    @ApiModelProperty("应用分类编码")
    private String tenantGroupCode;

    /**
     * 应用分类名称
     */
    @ApiModelProperty("应用分类名称")
    private String tenantGroupName;

    /**
     * 分类创建公司
     */
    @ApiModelProperty("分类创建公司")
    private String tenantGroupCompanyCode;

    /**
     * 上级code
     */
    @ApiModelProperty("上级code")
    private String tenantGroupPcode;

    /**
     * 应用类别设备级、生态级等
     */
    @ApiModelProperty("应用类别设备级、生态级等")
    private String tenantType;

    /**
     * 分类版本
     */
    @ApiModelProperty("分类版本")
    private String tenantGroupVersion;

    /**
     * 显示顺序
     */
    @ApiModelProperty("显示顺序")
    private Integer tenantGroupOrderNo;

    /**
     * 提交人id
     */
    @ApiModelProperty("提交人id")
    private String tenantGroupUserId;

    /**
     * 提交人姓名
     */
    @ApiModelProperty("提交人姓名")
    private String tenantGroupUserName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Timestamp tenantGroupCtime;

    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Timestamp tenantGroupMtime;

    /**
     * 是否删除
     */
    @ApiModelProperty("是否删除")
    private Short isDelete;

    /**
     * 应用树层级 1:应用分组层  2:应用层
     */
    @ApiModelProperty("应用树层级 1:应用分组层  2:应用层")
    private String tenantGroupLevel;



    //上级分类名称

    @ApiModelProperty("上级分类名称")
    @TableField(exist = false)
    private String classIfy;

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getTenantGroupCode() {
        return tenantGroupCode;
    }

    public void setTenantGroupCode(String tenantGroupCode) {
        this.tenantGroupCode = tenantGroupCode;
    }

    public String getClassIfy() {
        return classIfy;
    }

    public String getTenantGroupName() {
        return tenantGroupName;
    }

    public void setTenantGroupName(String tenantGroupName) {
        this.tenantGroupName = tenantGroupName;
    }

    public String getTenantGroupCompanyCode() {
        return tenantGroupCompanyCode;
    }

    public void setTenantGroupCompanyCode(String tenantGroupCompanyCode) {
        this.tenantGroupCompanyCode = tenantGroupCompanyCode;
    }

    public String getTenantGroupPcode() {
        return tenantGroupPcode;
    }

    public void setTenantGroupPcode(String tenantGroupPcode) {
        this.tenantGroupPcode = tenantGroupPcode;
    }

    public String getTenantType() {
        return tenantType;
    }

    public void setTenantType(String tenantType) {
        this.tenantType = tenantType;
    }

    public String getTenantGroupVersion() {
        return tenantGroupVersion;
    }

    public void setTenantGroupVersion(String tenantGroupVersion) {
        this.tenantGroupVersion = tenantGroupVersion;
    }

    public Integer getTenantGroupOrderNo() {
        return tenantGroupOrderNo;
    }

    public void setTenantGroupOrderNo(Integer tenantGroupOrderNo) {
        this.tenantGroupOrderNo = tenantGroupOrderNo;
    }

    public String getTenantGroupUserId() {
        return tenantGroupUserId;
    }

    public void setTenantGroupUserId(String tenantGroupUserId) {
        this.tenantGroupUserId = tenantGroupUserId;
    }

    public String getTenantGroupUserName() {
        return tenantGroupUserName;
    }

    public void setTenantGroupUserName(String tenantGroupUserName) {
        this.tenantGroupUserName = tenantGroupUserName;
    }

    public Timestamp getTenantGroupCtime() {
        return tenantGroupCtime;
    }

    public void setTenantGroupCtime(Timestamp tenantGroupCtime) {
        this.tenantGroupCtime = tenantGroupCtime;
    }

    public Timestamp getTenantGroupMtime() {
        return tenantGroupMtime;
    }

    public void setTenantGroupMtime(Timestamp tenantGroupMtime) {
        this.tenantGroupMtime = tenantGroupMtime;
    }

    public Short getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Short isDelete) {
        this.isDelete = isDelete;
    }

    public String getTenantGroupLevel() {
        return tenantGroupLevel;
    }

    public void setTenantGroupLevel(String tenantGroupLevel) {
        this.tenantGroupLevel = tenantGroupLevel;
    }

    public OcpTenantGroup setClassIfy(String classIfy) {
        this.classIfy = classIfy;
        return null;
    }
}
