package com.pms.ocp.model.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.sql.Timestamp;

@Data
@Accessors(chain = true)
@ApiModel("服务订阅记录表")
public class PmsApiSubs {

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    @ApiModelProperty("服务编码")
    private String apiCode;

    @ApiModelProperty("服务订阅创建时间")
    private Timestamp subsLogApiCtime;

    @ApiModelProperty("服务订阅修改时间")
    private Timestamp subsLogApiMtime;

    @ApiModelProperty("服务订阅创建用户ID")
    private String subsLogApiUserId;

    @ApiModelProperty("服务订阅添加时间")
    private Timestamp subsLogApiAtime;

    @ApiModelProperty("公司编码")
    private String subsCompanyCode;

    @ApiModelProperty("是否删除0-否，1-是")
    private long isDelete;




    @ApiModelProperty("服务接口中文名称")
    private String apiName;

    @ApiModelProperty("服务分类代码")
    private String apiGroupCode;

    @ApiModelProperty("推广类型0:统建；1:自建")
    private long apiPromotion;

    @ApiModelProperty("服务请求体")
    private String apiReq;

    @ApiModelProperty("服务返回体")
    private String apiResp;

    @ApiModelProperty("服务地址")
    private String apiUrl;

    @ApiModelProperty("服务创建时间")
    private Timestamp apiCtime;

    @ApiModelProperty("服务修改时间")
    private Timestamp apiMtime;

    @ApiModelProperty("创建者用户ID")
    private String apiUserId;

    @ApiModelProperty("建设单位")
    private String apiUnit;

    @ApiModelProperty("服务所属公司")
    private String ownerCompanyCode;

    @ApiModelProperty("服务所属公司")
    private String ownerCompanyName;

    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private long apiZone;

    @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private long apiLayer;

    @ApiModelProperty("服务版本（最新版本）")
    private String apiVersion;

    @ApiModelProperty("服务所属中心编码所属中心")
    private long apiCenterCode;


    @ApiModelProperty("创建者姓名")
    private long apiUserName;






}
