package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.OcpApiBaseMapper;
import com.pms.ocp.mapper.OcpApiTreeMapper;
import com.pms.ocp.model.QueryResponseResult;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.OcpApiGroup;

import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.service.OcpApiTreeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Stream;


@Service
@Slf4j
public class OcpApiTreeServiceImpl extends ServiceImpl<OcpApiTreeMapper, OcpApiGroup> implements OcpApiTreeService {


    @Autowired
    private OcpApiTreeMapper mapper;

    @Autowired
    private OcpApiBaseMapper ocpApiBaseMapper;

    /**
     * 服务树分类
     *
     * @return
     */

    @Override
    public List<OcpApiGroup> getByGroup(Long apiGroupPromotionType, String apiGroupCode) {

        if (!("".equals(apiGroupPromotionType)) && StringUtils.isBlank(apiGroupCode)) {
            List<OcpApiGroup> ocpApiGroups = mapper.selectTwoApiGroups(apiGroupPromotionType);
            return ocpApiGroups;
        } else if (!("".equals(apiGroupPromotionType)) && !(StringUtils.isBlank(apiGroupCode))) {
            List<OcpApiGroup> ocpApiGroups = mapper.selectThreeApiGroupsList(apiGroupPromotionType, apiGroupCode);
            return ocpApiGroups;
        }

        return null;
    }


    /**
     * 新增服务分类
     *
     * @param
     */
    @Override
    public OcpApiGroup insertTree(OcpApiGroup ocpApiGroup) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String code = RandomStringUtils.getRandomString(6);
        boolean flag = true;
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
        Stream<OcpApiGroup> ocpApiGroupStream = ocpApiGroups.stream().filter(item -> item.getApiGroupCode().equals(ocpApiGroup.getApiGroupPcode()));
        Stream<OcpApiGroup> apiGroupStream1 = ocpApiGroupStream.filter(ocp -> ocp.getApiGroupName().equals(ocpApiGroup.getApiGroupName()));
        OcpApiGroup ocpApi = new OcpApiGroup();
        if (!(StringUtils.isBlank(apiGroupStream1.toString()))) {

            ocpApi.setApiGroupPromotionType(ocpApiGroup.getApiGroupPromotionType());
            BeanUtils.copyProperties(ocpApiGroup, ocpApi);
            ocpApi.setObjId("");
            ocpApi.setApiGroupMtime(timestamp);
            ocpApi.setApiGroupCtime(timestamp);
            ocpApi.setApiGroupPcode(ocpApiGroup.getApiGroupCode());
            ocpApi.setApiGroupCode(code);
            ocpApi.setApiGroupPromotionType(ocpApiGroup.getApiGroupPromotionType());
            if ("Middleground".equals(ocpApiGroup.getApiGroupLevel())) {
                ocpApiGroup.setApiGroupLevel("sys_center");
            }
            if ("sys_center".equals(ocpApiGroup.getApiGroupLevel())) {
                ocpApiGroup.setApiGroupLevel("api_group");
            }
            mapper.insert(ocpApi);
        } else {
            return ocpApi;
        }
        return ocpApi;

    }


    /**
     * 修改服务分类
     *
     * @param
     */
    @Override
    public boolean updataOcpTree(OcpApiGroup ocpApiGroup) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        boolean falg = true;
        List<OcpApiGroup> ocpApiGroups = mapper.selectList(null);
        for (OcpApiGroup apiGroup : ocpApiGroups) {
            String code = apiGroup.getApiGroupCode();
            if (code == ocpApiGroup.getApiGroupCode()) {
                falg = false;
                break;
            }
        }
        ocpApiGroup.setApiGroupMtime(timestamp);
        mapper.updateById(ocpApiGroup);
        return falg;
    }


    /**
     * 删除服务分类
     *
     * @param ocpApiGroup
     */
    @Override
    public boolean deleteOcpTree(OcpApiGroup ocpApiGroup) {
        boolean flag = true;
        LambdaQueryWrapper<OcpApiGroup> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(OcpApiGroup::getApiGroupCode, ocpApiGroup.getApiGroupCode());
        String objId = ocpApiGroup.getObjId();
        if (StringUtils.isBlank(ocpApiGroup.getApiGroupCode())) {
            flag = false;
        } else {

            LambdaQueryWrapper<OcpApiGroup> eq = queryWrapper.eq(OcpApiGroup::getApiGroupPcode, ocpApiGroup.getApiGroupCode());
            if (StringUtils.isBlank(eq.toString())) {
                flag = false;
            }
        }
        if (flag) {
            mapper.deleteById(objId);
        }
        return flag;
    }


    /**
     * 服务列表分级查询
     *
     * @param pageGroupDto
     * @return
     */
    @Override
    public Page<OcpApiGroup> getOnePages(PageGroupDto pageGroupDto) {
        Page pageInfo = new Page(pageGroupDto.getPageNum(), pageGroupDto.getPageSize());
        LambdaQueryWrapper<OcpApiGroup> qw = new LambdaQueryWrapper<>();
        if (!("".equals(pageGroupDto.getKeyword()))) {
            if (StringUtils.isBlank(pageGroupDto.getApiGroupLevel())) {

                qw.eq(OcpApiGroup::getApiGroupPromotionType, pageGroupDto.getApiGroupPromotionType());
               mapper.selectPage(pageInfo, qw);

            } else if ("Middleground".equals(pageGroupDto.getApiGroupLevel()) || "sys_center".equals(pageGroupDto.getApiGroupLevel()) || "api_group".equals(pageGroupDto.getApiGroupLevel())) {
                List<OcpApiGroup> ocpApiGroups = mapper.selectLists(pageGroupDto.getApiGroupPromotionType(), pageGroupDto.getApiGroupCode());
                pageInfo.setRecords(ocpApiGroups);
                pageInfo.setTotal(ocpApiGroups.size());
            }
        } else {
            LambdaQueryWrapper<OcpApiGroup> ocpTenantGroupLambdaQueryWrapper = qw.and(c -> c.like(OcpApiGroup::getApiGroupName, pageGroupDto.getKeyword()))
                    .or().like(OcpApiGroup::getApiGroupUserName, pageGroupDto.getKeyword())
                    .or().like(OcpApiGroup::getApiGroupPcode, pageGroupDto.getKeyword());
            mapper.selectPage(pageInfo, ocpTenantGroupLambdaQueryWrapper);
        }
        return pageInfo;
    }
}


