package com.pms.ocp.service.impl;


import cn.afterturn.easypoi.cache.manager.IFileLoader;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.utils.RandomStringUtils;
import com.pms.ocp.mapper.TenantBasicManagementMapper;
import com.pms.ocp.mapper.TenantMapper;
import com.pms.ocp.model.dto.*;
import com.pms.ocp.model.entity.ModelAudit;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.service.TenantService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.*;


@Service
public class TenantServiceImpl extends ServiceImpl<TenantMapper, OcpTenantGroup> implements TenantService {


    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private TenantBasicManagementMapper tenantBasicMapper;

    /**
     * 应用树分类管理
     *
     * @return
     */
    @Override
    public List<OcpTenantGroup> getTree(String tenantGroupCompanyCode, String tenantGroupCode) {
        List<OcpTenantGroup> ocpTenantGroupList = null;
        if (StringUtils.isBlank(tenantGroupCode) && StringUtils.isBlank(tenantGroupCompanyCode)) {
            //顶级目录
            ocpTenantGroupList = tenantMapper.oneTenantGroup();
        } else if (!(StringUtils.isBlank(tenantGroupCompanyCode)) && StringUtils.isBlank(tenantGroupCode)) {
            //二级目录
            ocpTenantGroupList = tenantMapper.selectGroups(tenantGroupCompanyCode);
        } else if (!(StringUtils.isBlank(tenantGroupCompanyCode)) && !(StringUtils.isBlank(tenantGroupCompanyCode))) {
            //三级目录
            ocpTenantGroupList = tenantMapper.selectTenantGroups(tenantGroupCode, tenantGroupCompanyCode);


        }
        return ocpTenantGroupList;
    }

    /**
     * 应用新增
     *
     * @param
     * @return
     */
    @Override
    public OcpTenantGroup getTenanInster(TenanBaseDto tenanBaseDto) {
        boolean falg = true;

        OcpTenantGroup group = new OcpTenantGroup();
        String tenantGroupCode = tenanBaseDto.getTenantGroupCode();
        List<OcpTenantGroup> ocpTenantGroups = tenantMapper.selectList(null);

        String randomString = RandomStringUtils.getRandomString(6);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        BeanUtils.copyProperties(tenanBaseDto, group);
        group.setTenantGroupPcode(tenanBaseDto.getTenantGroupCode());
        group.setTenantType("应用");
        group.setTenantGroupVersion("1.0");
        group.setTenantGroupCode(randomString);
        group.setTenantGroupOrderNo(1);
        group.setTenantGroupCtime(timestamp);
        group.setTenantGroupMtime(timestamp);
        group.setTenantGroupVersion("1.0");
        group.setTenantGroupCode(randomString);
        if (tenanBaseDto.getTenantGroupLevel().equals("Middleground")){
            group.setTenantGroupLevel("sys_center");
        }
        if (tenanBaseDto.getTenantGroupLevel().equals("sys_center")){
            group.setTenantGroupLevel("api_group");
        }
        group.setClassIfy(tenanBaseDto.getTenantGroupCompanyCode());

        //判断是否含有相同的分类名称
        if (falg) {
            tenanBaseDto.setClassIfy(tenanBaseDto.getTenantGroupCode());
            tenantMapper.insert(group);
        }


        return group;
    }

    /**
     * 修改应用
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean getTenantUpdata(OcpTenantGroup ocpTenantGroup) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        boolean falg = true;
        List<OcpTenantGroup> ocpTenantGroupList = tenantMapper.selectList(null);
        for (OcpTenantGroup ocpApiGroup : ocpTenantGroupList) {
            String code = ocpTenantGroup.getTenantGroupCode();
            if (code == ocpApiGroup.getTenantGroupCode()) {
                falg = false;
                break;
            }
        }
        OcpTenantGroup ocpTenantGroup1 = new OcpTenantGroup();
        ocpTenantGroup1.setTenantGroupMtime(timestamp);
        tenantMapper.updateById(ocpTenantGroup);

        return falg;
    }

    /**
     * 删除服务
     *
     * @param ocpTenantGroup
     * @return
     */
    @Override
    public boolean gettenantDelete(OcpTenantGroup ocpTenantGroup) {
        String objId = ocpTenantGroup.getObjId();
        OcpTenantGroup ocpTenantGroup1 = tenantMapper.selectById(objId);
        boolean flag = true;
        LambdaQueryWrapper<OcpTenantGroup> wrapper = new LambdaQueryWrapper<>();
        LambdaQueryWrapper<OcpTenantGroup> lambdaQueryWrapper = wrapper.eq(OcpTenantGroup::getTenantGroupPcode, ocpTenantGroup1.getTenantGroupCode());
        if (!(StringUtils.isBlank(lambdaQueryWrapper.toString()))){
             tenantMapper.deleteById(objId);
         }else {
             flag = false;
         }

        return flag;
    }

    /**
     * 应用--查询
     *
     * @param tenantGroupCode
     * @param tenantGroupCompanyCode
     * @return
     */
    @Override
    public Page<OcpTenantGroup> getselects(String tenantGroupCode, String tenantGroupCompanyCode, int currentPage, int pageSize, String keyword,String lev) {
        LambdaQueryWrapper<OcpTenantGroup> qw = new LambdaQueryWrapper<>();
        Page<OcpTenantGroup> page = new Page<>(currentPage, pageSize);
        if (StringUtils.isBlank(keyword)) {
         if("".equals(lev) || "1".equals(lev)) {
             LambdaQueryWrapper<OcpTenantGroup> eq = qw.eq(OcpTenantGroup::getTenantGroupCompanyCode, tenantGroupCompanyCode);
              tenantMapper.selectPage(page, eq);
         }else if ("2".equals(lev) || "3".equals(lev)) {
                LambdaQueryWrapper<OcpTenantGroup> eq = qw.or(wq -> wq.eq(OcpTenantGroup::getTenantGroupCompanyCode, tenantGroupCompanyCode)).eq(OcpTenantGroup::getTenantGroupPcode, tenantGroupCode);
                tenantMapper.selectPage(page, eq);
            }
        } else if (!(StringUtils.isBlank(keyword))) {
            LambdaQueryWrapper<OcpTenantGroup> ocpTenantGroupLambdaQueryWrapper = qw.and(c -> c.like(OcpTenantGroup::getTenantGroupCompanyCode, keyword))
                    .or().like(OcpTenantGroup::getTenantGroupName, keyword)
                    .or().like(OcpTenantGroup::getTenantGroupPcode, keyword)
                    .or().like(OcpTenantGroup::getTenantGroupUserName, keyword);
            tenantMapper.selectPage(page, ocpTenantGroupLambdaQueryWrapper);
        }
        return page;
    }
}





