package com.pms.ocp.common.constants;

import lombok.Getter;

/**
 * @author wuwanli
 * @version 1.0
 * @date 2021/8/4
 */
public enum CodeEnum {
    /**
     * 处理成功
     */
    SUCCESS("200", "处理成功", true),
    /**
     * 必填参数为空
     */
    REQUIRED_PARAMETER_EMPTY("0", "必填参数为空", false),
    /**
     * 参数类型错误
     */
    PARAMETER_TYPE_ERROR("0", "Parameter type error", false),
    /**
     * 未登录
     */
    NOT_LOGIN("401001", "用户未登录", false),
    /**
     * 用户名或密码错误
     */
    LOGIN_FAIL("401002", "用户名或密码错误", false),
    /**
     * 无权限访问
     */
    NO_PERMISSION("401003", "无权限访问", false),
    /**
     * 系统异常
     */
    UNKNOWN("9999", "System abnormal", false),
    /**
     * 数据异常
     */
    NO_DATA("555", "数据库数据异常", false),
    UP_DATA_FAIL("401005", "更新失败", false),
    INSERT_FAIL("401006", "插入数据失败", false);

    /**
     * 构造函数
     *
     * @param code 响应码
     * @param desc 响应描述
     */
    CodeEnum(String code, String desc, boolean success) {
        this.code = code;
        this.desc = desc;
        this.success = success;
    }

    @Getter
    private final String code;

    @Getter
    private final String desc;
    @Getter
    private final boolean success;

}