package com.pms.ocp.common.constants;

import java.math.BigDecimal;

public interface Constant {

    /**
     * 系统参数
     */
    interface SYSTEM {
        /**
         * 系统名称
         */
        String NAME = "全口径房地资源管理系统";
    }

    /**
     * 异常类常量值
     */
    interface Exception {
        String ERRORSQL = "Error SQL";

        /**
         * 巡店接口返回
         */
        String ERROR = "error";
    }

    /**
     * excel 参数
     */
    interface ExcelConfig {
        /**
         * excel缓存
         */
        String EXCEL_KEY_PREFIX = "excel:cache:%s";
    }


    /**
     * 常用列名
     */
    interface ColumnName {
        String IS_DEL = "is_del";
    }


    /**
     * 返回结果 success：成功，fail：业务返回的失败，error：非业务异常失败
     */
    interface ReqResult {
        /**
         * 成功
         */
        String SUCCESS = "success";
        /**
         * 失败
         */
        String FAIL = "fail";
        /**
         * 异常
         */
        String ERROR = "error";
    }

    /**
     * 常用数值
     */
    interface Number {
        Integer MINUS_ZERO = -1;
        Integer TWENTY = 20;
        Integer THIRTY = 30;
        Integer ZERO = 0;
        Integer ONE = 1;
        Integer TWO = 2;
        Integer THREE = 3;
        Integer FOUR = 4;
        Integer FIVE = 5;
        Integer SIX = 6;
        Integer SEVEN = 7;
        Integer EIGHT = 8;
        Integer NINE = 9;
        Integer TEN = 10;
        Integer TWENTYFOUR = 24;
        Integer TWENTYFIVE = 25;
        Integer TWENTYSIX = 26;
        Integer THIRTYTWO = 32;
        Integer THIRTYTHREE = 33;
        Integer THIRTYFOUR = 34;
        Integer THIRTYSIX = 36;
        Integer FOURTY = 40;
        Integer FORTYTWO = 42;
        Integer LENGTH = 3;
        Integer NINETYNINE = 99;
        Integer ONEHUNDRED = 100;
        Integer ONETHOUSAND = 1000;
        Integer TENTHOUSAND = 10000;
        Integer TENMILLION = 10000000;
        Integer ELEVEN = 11;
        Long ZEROL = 0L;
        Long ONEL = 1L;
        Long COMPANY = 2L;
        Long BUSINESS = 3L;
        Long ONETHOUSANDL = 1000L;
        Byte ONEB = 1;
        Byte TWOB = 2;
        Byte THREEB = 3;
        Byte ANTI_INITLIZED = 0;
        Byte INITLIZED = 1;
        Double ZBXS = 0.01;
        BigDecimal ZEROB = new BigDecimal(0);
        BigDecimal ONEHUNDREDB = new BigDecimal(100);
        BigDecimal TENTHOUSANDB = new BigDecimal(10000);
    }

    /**
     * 当前环境 dev：开发, test：测试, prod：生产
     */
    interface ProfileActive {
        /**
         * 开发环境
         */
        String DEV = "dev";
        /**
         * 测试环境
         */
        String TEST = "test";
        /**
         * 私人测试文件
         */
        String TEST_ONE ="test1";
        /**
         * 生产环境
         */
        String PROD = "prod";
        /**
         * 联调环境
         */
        String LIANTIAO = "liantiao";
        /**
         * 本机
         */
        String HOST = "host";
        /**
         * 南瑞部门提测
         */
        String TESTNARI = "testnari";
    }

    /**
     * Service缓存value
     */
    interface RedisCache {
        /**
         * Redis key 分隔符（@Cacheable自动生成的分隔符）
         */
        String redisSeparator = "::";
        /**
         * 设置累计访问redis key
         */
        String CUMULATIVE_NUMBER = "cumulativeNumber";

        /**
         * 在线人数
         */
        String ONLINE_NUMBER= "onlineNumber";
    }

    /**
     * 系统配置
     */
    interface SysConfig {
        /**
         * 同步锁自动超时时间(单位:秒)
         */
        long REDIS_LOCK_TIMEOUT = 20;
        /**
         * 凭证操作同步锁自动释放时间(单位:秒)
         */
        long VOUCHER_LOCK_TIMEOUT = 60;
        /**
         * 结账操作锁自动释放时间(单位:秒)
         **/
        long SETTLE_ACCOUNT_LOCK_TIMEOUT = 60 * 20;
        /**
         * 结账后是否允许修改现金流量
         **/
        byte SETTLE_ALLOW_EDIT_CASH_FLOW = 1;
        /**
         * 记录超时接口阈值
         **/
        long LONG_TIME_THRESHOLD = 1000;
        /**
         * 预警耗时日志打印
         **/
        String LONG_OUT_TIME_LOG = "接口预警：接口：{} 耗时：{}毫秒";
        /**
         * 预警耗时日志打印
         **/
        String LONG_TIME_LOG = "接口耗时：接口：{} 耗时：{}毫秒";
    }


    /**
     * 常用字符
     */
    interface Character {
        String ENTITY = "'entity";
        String TXT = ".txt";
        String BRACKETS = "(";
        String GROUP_CODE = "0000";
        String QUESTION = "?";
        String EQUALS = "=";
        String AND = "&";
        String COLON = ":";
        String ASTERISK = "*";
        String POINT = ".";
        String COMMA = ",";
        String BRACKET_LEFT_B = "{";
        String BRACKET_RIGHT_B = "}";
        String ZERO = "00";
        String ONE = "001";
        String String_ZERO = "0";
        String String_ZEROB = "0.00";
        String NULL_VALUE = "";
        String UNDER_LINE = "_";
        String MIDDLE_LINE = "-";
        String MIDDLE_WAVE = "～";
        String VIRGULE = "/";
        Byte FAIL = 0;
        Byte SUCCESS = 1;
        Byte IS_REFERENCE = 2;
        String Percent = "%";
        String UTF8 = "utf-8";
        String HASH_SIGN = "#";
        String COMMA_SINGLE_QUOTE_SEPERATOR = "','";
        String DOUBLE_COMMA = ",,";
        String ON = "ON";
        String OFF = "OFF";
        String TIP_FLAG = "tipFlag";
        String ALIAS_R = "r";
        String ZEROZRRO = "0.00";
        String AllCOUNT = "AllCount";
        String FILE = "class";
        String STRINGONE = "1";
        String STRINGTWO = "2";
        String STRINGTHREE = "3";
        String STRINGFOUR = "4";
        String STRINGFIVE = "5";
        String land = "land";
        String build = "build";
        String NO = "否";
        String YES = "是";
        String NOHAVA = "无";
        String GB2312 = "gb2312";
        String text2312 = "text/plain;charset=gb2312";
        String QUERYAFTERMODIFICATION= "QueryAfterModification";
        String APPLICATION_PATH_IN_NACOS= "applicationPathInNacos";
        String IP_VERIFY = "^((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]?\\d)$";
        String COMPUTER_NAME = "COMPUTERNAME";
        String DIMENSIONENTITY_PATH = "com.sgcc.nari.common.entity.requestEntity.DimensionEntity";
        String RETURNVALUE = "returnValue";
        String PARAMETER_VALUE = "parameterValue";

    }


    /**
     * 是否
     */
    interface Is {
        Byte YES = 1;
        Byte NO = 0;
        Integer NO_INT = 0;
        Integer YES_INT = 1;
    }

    /**
     * FTP
     */
    interface ftpCode {
        /**
         * word后缀
         */
        String FORMATSUFFIX = ".docx";
        /**
         * 报告前缀名称
         */
        String REPORTNAME = "全口径房地资源报告";
        /**
         * 报告前缀名称
         */
        String REPORTSHORTNAME = "realLandResourceReport";
        /**
         * 模板地址
         */
        String MOULDPATH = "mouldPath";
        /**
         * 模板名称
         */
        String MOULDNAME = "mouldName";
        /**
         * 简称
         */
        String SHORTNAME = "shortName";
    }

    /**
     * 正则表达式常量
     */
    interface RegExp {
        /**
         * 括号，包括大括号和小括号
         */
        String BRACKETS = "\\{|\\}|\\(|\\)";
        /**
         * 不可见字符
         */
        String INVISIBLE = "\\s";
        /**
         * 运算符 加减乘除
         */
        String OPERATOR = "\\+|\\-|\\*|\\/";
        /**
         * 数字，包括整形和浮点型
         */
        String NUMBER = "'(\\d|\\.)+'";
        /**
         * 逗号开头或结尾
         */
        String COMMA_START_OR_END = "^,|,$";
        /**
         * 井号左括号
         */
        String HASH_SIGN_BRACKET_LEFT = "#\\{";
        /**
         * 右括号
         */
        String BRACKET_RIGHT = "\\}";
        /**
         * #{内容}，占位符内容
         */
        String PLACE_HOLDER_CONTENT = "#\\{([^}])*\\}";
        /**
         * #{参数map.
         */
        String PLACE_HOLDER_PARAM_MAP = "#\\{paramMap.";
        /**
         * 井号或者大括号
         */
        String HASH_SIGN_BRACKETS = "#|\\{|\\}";
        /**
         * 空请求体
         */
        String EMPTY_REQUEST_BODY = "\\{\\s+\\}";
    }

    /**
     * 中文转换
     */
    interface STRINGNAME {
        /**
         * 全部
         */
        String ALL = "全部";
    }

    /**
     * 登陆参数
     */
    interface LOGUSED {
        /**
         * 操作系统名称
         */
        String OPERATING_SYSTEM = "os.name";
        /**
         * 操作系统架构
         */
        String OPERATING_SYSTEM_FRAMEWORK = "os.arch";
        /**
         * 登陆token标识
         */
        String AUTHORIZATION = "authorization";

        /**
         * ticket
         */
        String TICKET = "ticket";

        /**
         * token
         */
        String TOKEN = "token";
    }

    /**
     * 加密用
     */
    interface cipher {
        /**
         * 前台sm2加密key
         */
        String DECRYPT = "encryptData";
    }


    /**
     * 所属分类
     */
    interface Category {
        /**
         * 规划用途
         */
        String PLANPURPOSE = "规划用途";

        /**
         * 土地性质
         */

        String LANDCHARACTER = "土地性质";
        /**
         * 土地使用权类型
         */
        String LANDUSETYPECODE = "土地使用权类型";

        /**
         * 行政区域
         */
        String ORGANIZATION = "行政区域";

        /**
         * 来源
         */
        String SOURCE = "来源";

        /**
         * 投资来源
         */
        String INVESTRESOURCE = "投资来源";


        /**
         * 房产分类
         */
        String BUILDTYPE = "房产分类";

        /**
         * 无证原因
         */
        String NOLICENSEREASON = "无证原因";

        /**
         * 单位级别
         */
        String UNITLEVELCODE = "单位级别";

        /**
         * 业务类型
         */
        String BUSINESSTYPE = "业务类型";
    }

    /**
     * 单位级别
     */
    interface unitLevelCode {
        //总部
        String HEADQUARTERS_LEVEL = "1";

        //分部
        String SUBSECTION_LEVEL = "2";

        //省
        String PROVINCE_LEVEL = "3";

        //市
        String CITY_LEVEL = "4";

        //县
        String COUNTY_LEVEL = "5";

    }

    /**
     * 请求方式
     */
    interface METHOD {
        //REQUEST
        String GET = "GET";
        //POST
        String POST = "POST";
    }

    /**
     * 字段类型
     */
    interface CATEGORYTYPE {
        /**
         * 土地规划用途
         */
        String PLANPURPOSE = "规划用途";

        /**
         * 土地性质
         */
        String LANDCHARACTER = "土地性质";

        /**
         * 土地使用权类型
         */
        String LANDUSETYPE = "土地使用权类型";

        /**
         * 无证原因
         */
        String NOLICENSEREASON = "无证原因";

        /**
         * 来源
         */
        String SOURCE = "来源";

        /**
         * 投资来源
         */
        String INVESTSOURCE = "投资来源";

        /**
         * 房产分类
         */
        String REALESTATETYPE = "房产分类";

        /**
         * 行政区域
         */
        String AREA = "行政区域";
    }

    /**
     * 日志操作类型
     */
    interface LOGHANDLETYPE {

        /**
         * 查看
         */
        String SELECT = "查看";

        /**
         * 添加
         */
        String INSERT = "新增";

        /**
         * 删除
         */
        String DELETE = "删除";

        /**
         * 修改
         */
        String UPDATE = "修改";
    }

    /**
     * 图片上传下载
     */
    interface pictureConstant {
        /**
         * 排序
         */
        String SORT = "[^0-9]";
        /**
         * "redisKey",
         */
        String REDISKEY = "redisKey";
        /**
         * line.separator
         */
        String LINE_SEPARATOR= "line.separator";
        /**
         * 校验图片格式正则
         */

        String PICTURE_FORMAT = "^(.+?)\\.(png|jpg|gif|jpeg|bmp|PNG|JPG|GIF|JPEG|BMP)$";
        /**
         * 正则
         */
        String PICREGEX = ".*[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？\\\\]+.*";
        /**
         * JPG
         */
        String JPG = "JPG";
        /**
         * JEPG
         */
        String JPEG = "JPEG";
        /**
         * PNG
         */
        String PNG = "PNG";
        /**
         * GIF
         */
        String GIF = "GIF";
        /**
         * BMP
         */
        String BMP = "BMP";
        /**
         * 行号
         */
        String LINENUMBER = "行号:";
        String HP = "http://";

    }

    /**
     * 日志监控参数
     */
    interface MONITOR {
        /**
         * 审计人员角色
         */
        String AUDITROLE = "审计人员";

        /**
         * 审计日志
         */
        String AUDITLOG = "审计日志";

        /**
         * 系统维护
         */
        String SYSTEMMAINTAIN = "系统维护人员";

        /**
         * 系统服务
         */
        String SYSTEMSERVICE = "系统服务";

        /**
         * 系统告警
         */
        String SYSTEMWARNING = "系统告警";
    }

    /**
     * 消息类型
     */
    interface NOTIFICATION_MESSAGE_TYPE {
        /**
         * PC
         */
        int PC = Number.ZERO;

        /**
         * 邮件
         */
        int MAIL = Number.ONE;

        /**
         * 短信
         */
        int TEXT_MESSAGE = Number.TWO;

        /**
         * 微信
         */
        int WECHAT = Number.THREE;

        /**
         * 其它
         */
        int OTHER = Number.FOUR;
    }

    /**
     * 消息类型
     */
    interface NOTIFICATION_BUSINESS_TYPE {
        /**
         * 消息
         */
        int MESSAGE = 1;

        /**
         * 告警
         */
        int WARNING = 2;
    }

    /**
     * 告警标题
     */
    interface WARNING_HEAD {
        /**
         * 日志容量告警
         */
        String AUDIT_SIZE_WARNING_HEAD = "日志容量告警";

        /**
         * 审计日志
         */
        String TABLE_NAME = "审计日志";

    }

    /**
     * 告警内容
     */
    interface WARNING_CONTENT {
        /**
         * 日志容量告警
         */
        String AUDIT_SIZE_WARNING_CONTENT = "当前日志容量已经超过监控阈值,监控阈值为 %s MB,当前实际产生容量为 %s MB,请尽快处理！";
    }

    /**
     * ISC邮件信息配置
     */
    interface ISCEMAIL {
        /**
         * ISC邮件信息配置
         */
        String SENDEMAIL = "qkjfdzyxt@isc.com";
    }
}
