package com.pms.ocp.common.constants;

/**
 * 异常枚举类
 */
public enum ResultCode {
	/* ============================ 通用错误码 ========================== **/
	/**
	 * 禁止访问 303
	 **/
	PARAMS_NOT(303, "缺少参数"),

	/**
	 * 存在错误参数 304
	 */
	PARAMS_NOT_RIGHT(304, "存在错误参数"),

	/**
	 * 存在错误测试数据 305
	 */
	DATA_ERROR(305, "存在错误测试数据"),

	/**
	 * 存在错误测试数据 305
	 */
	SERVER_ERROR(306, "服务异常"),
	/**
	 * 校验失败 307
	 **/
	VERIFICATION_FAIL(307, "校验失败"),

	/**
	 * 错误请求 400
	 **/
	BAD_REQUEST(400, "错误请求"),

	/**
	 * 未经授权 401
	 **/
	UNAUTHORIZED(401, "未经授权"),

	/**
	 * 禁止访问 403
	 **/
	FORBIDDEN(403, "禁止访问"),
	/**
	 * 连接超时
	 **/
	TIME_OUT(408, "连接超时"),
	/**
	 * Feign连接错误
	 **/
	FEIGN_CONNECT_ERROR(409, "feignClient 连接错误：%s"),
	/**
	* Feign连接错误
	 **/
	BAD_REQUEST_METHOD(410, "不合法的请求方式"),
	/**
	 * 操作异常 500
	 **/
	INTERNAL_SERVER_ERROR(500, "操作异常"),
	/**
	 * SQL异常
	 **/
	SQL_ERROR_EXCEPTION(501, "SQL执行异常!"),
	/**
	 * 操作失败
	 **/
	OPERATION_FAILURE(507, "操作失败"),
	/**
	 * 日期格式处理异常
	 **/
	DATE_FORMAT_EXCEPTION(508, "日期格式处理异常"),
	/**
	 * 项目启动文件异常
	 */
	SYSTEM_PROFILE_EXCEPTION(509, "错误的项目启动文件"),

	/* ============================ 业务/错误码 start========================== **/
	/* ===========================后台系统======================== **/
	RECORD_NOT_EXIST(10001, "相关记录不存在!"),
	SYS_USER_INVALID(10002, "用户登录已过期!"),
	PERMISSION_NOT(10003, "无访问权限!"),
	ACCOUNT_NOT(10004, "账号异常!"),
	SHIRO_ERROR(10005, "鉴权/授权过程出错!"),
	MENU_EXIST(10006, "菜单定义已存在！"),
	ROLE_EXIST(10007, "角色定义已存在！"),
	CODE_EXIST(10008, "编码已存在！"),
	NAME_EXIST(10009, "名称已存在!"),
	USER_ORGANIZATION_LEVEL_ERROR(10023, "用户组织机构关联层级有误！"),
	USER_ORGANIZATION_INFO_ERROR(10024,"用户组织机构信息有误！"),
	TOKEN_INVALID(9997, "登录失效，请重新登录！"),
	/* ============================ 文件处理 错误码 ========================== **/
	FILE_NOT_EXISTS(21001, "文件不存在"),
	FILE_MUST_IS_EXCEL(21002, "文件类型必须是excel"),
	UPLOAD_EXCEPTION(21003, "上传过程出现异常"),
	EXCEL_RULE_NOT_EXISTS(21004, "excel校验规则不存在"),
	EXCEL_TEMPLATE_NOT_EXISTS(21005, "excel模板不存在"),
	EXCEL_TEMPLATE_NOT_CORRECT(21009, "excel模板不对，请重新下载"),
	EXCEL_DATA_NOT_EXISTS(21006, "excle数据不存在"),
	EXCEL_NOT_CORRECT(21007, "excel不正确"),
	EXCEL_PARSE_CORRECT(21010,"excel解析错误"),
	CURRENT_MONTH_NOT_EXISTS(21008, "当前年月数据不存在"),
	BATCH_NOT_NEED(21009, "无需批量操作！"),
	CELL_IS_NULL(21010, "值不能为空"),
	CELL_FORMAT_ERROR(21011, "值格式不正确"),
	CELL_MIN_LENGTH_ERROR(21012, "值小于最小长度"),
	CELL_MAX_LENGTH_ERROR(21013, "值大于最大长度"),
	CELL_REGULAR_ERROR(21014, "值正则验证不通过"),
	CELL_OPTION_ERROR(21015, "值不在选项集范围内"),
	ROW_DUPLICATE_ERROR(21016, "行重复性校验未通过"),
	CELL_DATE_FORMAT_ERROR(21017,"日期范围格式不正确"),

	DATA_MISSING_UNITS(21018, "数据缺少单位级别编码"),
	PICTURE_NAME_ILLEGAL(21019, "图片名称不合法,请重新上传"),
	FILE_MUST_IS_PIC(21020, "图片格式不合法,请重新上传!"),
	NAME_CONFLICT(21021, "该组织机构下名称重复,请修改名称!"),
	ENCRYPT_ERROR_CODE(21022, "解密失败"),

	/* ===========================JoyhrError======================== **/
	SIGN_ERROR(80001,"签名验证错误!"),
	METHOD_ERROR(80002,"方法不存在!"),
	/* ===========================CrmHookError======================== **/
	CRM_MEMBER_FOUND_ERROR(81001,"会员信息已存在"),
	CRM_MEMBER_NOT_FOUND_ERROR(81002,"会员信息不存在"),

	/* =============主系统更改Error ================= **/
    MASTER_DATA_RELY_ERROR(90001,"切换系统与中台数据存在数据不匹配"),

    RELY_DATA_NOT_MATCH_BASE(90002,"切换系统依赖数据与中台数据存在不匹配数据"),

    BUS_DATA_NOT_MATCH_BASE(90003,"切换系统业务数据与中台数据存在不匹配数据"),

    DATA_MAPPING_NOT_MATCH_BASE(90004,"切换系统数据映射中数据与中台数据存在不匹配数据"),

	/* =============中台大平台系统 ================= **/
	LOGIN_TIME_OUT(130001,"登录失效或未登录，请重新登录"),
	VERFICATION_CODE_ERROR(130002,"验证码不正确"),
	NO_USER(130003,"用户不存在"),
	PASSWORD_ERROR(130004,"密码不正确"),
	MOBILE_USED(130005,"该手机号码已被注册"),
	BANK_ACCOUNT_USED(130006,"该银行账号已被使用"),
	OPEN_GOODS_FAIL(130009,"开通失败，请重新开通或联系相关人员"),
	PROBATION_GOODS_FAIL(130010,"试用失败，请重新试用或联系相关人员"),
	END_GOODS_FAIL(130011,"停用失败，请重新停用或联系相关人员"),
	FIND_ORDER_LIST_FAIL(130012,"查询订单列表失败，请重新查询或联系相关人员"),
	FIND_BILL_FAIL(130013,"查询账单列表失败，请重新查询或联系相关人员"),
	FIND_SIX_MONTH_BILL(130014,"查询近6个月消费失败"),
	FIND_MONTH_GOODS(130015,"查询该月份消费情况失败"),
	/* =============数据维护 ================= **/
	TOTAL_SYNC_RECORD_EXITS(110001,"已执行过全量同步！"),
	TOTAL_SYNC_RECORD_NOT_EXITS(110002,"还没执行全量同步！");

	public final int statusCode;
	public String msg;

	ResultCode(int statusCode, String msg) {
		this.statusCode = statusCode;
		this.msg = msg;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public String getMessage() {
		return msg;
	}

	public void setMessage(String msg) {
		this.msg = msg;
	}
}
