package com.pms.ocp.controller;


import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ApiDetailsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RequestMapping("/api-base/v1")
@RestController
@Api(tags = "服务库服务详情接口")
public class ApiDetailsController {
    @Autowired
    private ApiDetailsService apiDetailsService;

    @ApiOperation("服务库服务详情-查询")
    @GetMapping("/query")
    public ResponseVO<OcpApiBase> getApiDetails(String objId) {
        return apiDetailsService.getApiDetails(objId);
    }

}
