package com.pms.ocp.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pms.ocp.model.dto.PageOcpTenantDto;
import com.pms.ocp.model.dto.OcpTenantGroupDto;
import com.pms.ocp.model.dto.TenanBaseDto;
import com.pms.ocp.model.entity.OcpApiGroup;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.TenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Slf4j
@RequestMapping("/api-tenant/v1")
@RestController
@Api(tags = "应用树管理接口")
public class OcpTenantController {


    @Autowired
    private TenantService tenantService;
    /**
     * 应用树分类
     */

    @GetMapping("/tenanttree")
    @ApiModelProperty("应用树分类")
    private OcpTenantGroupDto getTenantTree(){
        OcpTenantGroupDto tree = tenantService.getTree();
        return tree;
    }

    @PostMapping("/tenantinster")
    @ApiModelProperty("新增应用")

    public ResponseVO tenantInster(@RequestBody TenanBaseDto TenanBaseDto){
      boolean falg =   tenantService.getTenanInster(TenanBaseDto);
      if (falg){
          return ResponseVO.ok("新建成功！");
      }
      return ResponseVO.error("应用code已经存在！");
    }

    @PostMapping("/tenantupdata")
    @ApiModelProperty("修改应用")
    public ResponseVO tenantUpdata(@RequestBody OcpTenantGroup ocpTenantGroup){
        boolean falg =   tenantService.getTenantUpdata(ocpTenantGroup);
        if (falg){
            return ResponseVO.ok("修改成功！");
        }
        return ResponseVO.error("应用code已经存在！");
    }
    @PostMapping("/tenantdelete")
    @ApiModelProperty("删除服务")
    public ResponseVO tenantDelete(@RequestBody OcpTenantGroup ocpTenantGroup){
        boolean falg =   tenantService.gettenantDelete(ocpTenantGroup);
        if (falg){
            return ResponseVO.ok("删除成功！");
        }
        return ResponseVO.error("应用下存在服务，请先删除下级应该！");
    }


    @PostMapping("tenantuse")
    @ApiOperation("应用分类--应用管理")
    public ResponseVO<List<OcpTenantGroup>> tenantUse(@RequestBody PageOcpTenantDto ocpTenantDto){
        List<OcpTenantGroup> onePages = tenantService.getsUse(ocpTenantDto);
        return ResponseVO.ok(onePages);
    }

    @PostMapping("tenantcase")
    @ApiOperation("应用分类--应用服务分页查")
    public ResponseVO<Page<OcpTenantGroup>> tenantCase(@RequestBody PageOcpTenantDto pageOcpTenantDto){
        Page<OcpTenantGroup> pages= tenantService.getOnePages(pageOcpTenantDto);

        return ResponseVO.ok(pages);
    }





}
