package com.pms.ocp.model.dto;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.pms.ocp.model.entity.OcpTenantGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.sql.Timestamp;

/**
 * 新增应用封装对象
 */
@ApiModel(value = "新增应用封装对象")
@Data
public class TenanBaseDto extends OcpTenantGroup {


    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    /**
     * 应用名称
     */
    @ApiModelProperty("应用名称")
    private String tenantName;

    /**
     * 应用代码
     */
    @ApiModelProperty("应用代码")
    private String tenantCode;

    /**
     * 应用分类代码
     */
    @ApiModelProperty("应用分类代码")
    private String tenantGroupCode;

    /**
     * 应用ip
     */
    @ApiModelProperty("应用ip")
    private String tenantIp;

    /**
     * 应用url
     */
    @ApiModelProperty("应用url")
    private String tenantUrl;

    /**
     * 所属专业
     */
    @ApiModelProperty("所属专业")
    private String professionalKind;

    /**
     * 创建者用户ID
     */
    @ApiModelProperty("创建者用户ID")
    private String tenantUserId;

    /**
     * 排序
     */
    @ApiModelProperty("排序")
    private Integer tenantOrderNo;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Timestamp tenantCtime;

    /**
     * 最后更新时间
     */
    @ApiModelProperty("最后更新时间")
    private Timestamp tenantMtime;

    /**
     * 部署名称
     */
    @ApiModelProperty("部署名称")
    private String deploymentName;

    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String tenantDescription;

    /**
     * 应用状态0:设计态；1:运行态
     */
    @ApiModelProperty("应用状态0:设计态；1:运行态")
    private Short tenantState;

    /**
     * 建设单位
     */
    @ApiModelProperty("建设单位")
    private String tenantUnit;

    /**
     * 所属公司编码
     */
    @ApiModelProperty("所属公司编码")
    private String ownerCompanyCode;

    /**
     * 所属公司名称
     */
    @ApiModelProperty("所属公司名称")
    private String ownerCompanyName;

    /**
     * 是否删除0:否;1:是
     */
    @ApiModelProperty("是否删除0:否;1:是")
    private Short isDelete;

    /**
     * 所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区
     */
    @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
    private Short tenantZone;

    /**
     * 所属层级 1:应用层;2:平台层;3:网络层;4:感知层;
     */
    @ApiModelProperty("所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
    private Short tenantLayer;

    /**
     * 应用版本（当前版本）
     */
    @ApiModelProperty("应用版本（当前版本）")
    private String tenantVersion;
}
