package com.pms.ocp.model.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import java.sql.Timestamp;
@Data
@Accessors(chain = true)
@TableName("ocp_api_audit")
@ApiModel("服务事记表")
public class OcpApiAudit {

  @TableId(type = IdType.ASSIGN_ID)
  @ApiModelProperty("主键ID")
  @Excel(name = "主键ID",orderNum = "1")
  private String objId;

  @ApiModelProperty("服务编码")
  @Excel(name = "服务编码",orderNum = "2")
  private String apiCode;

  @ApiModelProperty("操作状态0:新增,1:迭代；2，下线")
  @Excel(name = "操作状态",orderNum = "3")
  private long operStatus;

  @ApiModelProperty("操作对象0:服务，1:入参，2:出参")
  @Excel(name = "操作对象",orderNum = "4")
  private long operTarget;

  @ApiModelProperty("类型0:人工操作,1:流程管控,3:总部下发")
  @Excel(name = "操作对象",orderNum = "4")
  private long auditType;

  @ApiModelProperty("备注简述")
  @Excel(name = "备注简述",orderNum = "5")
  private String auditMessage;

  @ApiModelProperty("事记内容")
  @Excel(name = "事记内容",orderNum = "6")
  private String auditJson;

  @ApiModelProperty("提交人id")
  @Excel(name = "提交人id",orderNum = "7")
  private String auditUserId;

  @ApiModelProperty("提交人姓名")
  @Excel(name = "提交人姓名",orderNum = "8")
  private String auditUserName;

  @ApiModelProperty("创建时间")
  @Excel(name = "创建时间",orderNum = "9")
  private Timestamp auditCtime;

  @ApiModelProperty("修改时间")
  @Excel(name = "修改时间",orderNum = "10")
  private Timestamp auditMtime;

  @ApiModelProperty("是否删除0-否1-是")
  @Excel(name = "是否删除",orderNum = "11")
  private long isDelete;
  @ApiModelProperty("当前版本")
  @Excel(name = "当前版本",orderNum = "12")
  private long applyVersion;
  @ApiModelProperty("上一版本")
  @Excel(name = "上一版本",orderNum = "13")
  private long preApiVersion;

  @ApiModelProperty("服务接口中文名称")
  private String apiName;

  @ApiModelProperty("服务分类代码")
  private String apiGroupCode;

  @ApiModelProperty("推广类型0:统建；1:自建")
  private long apiPromotion;

  @ApiModelProperty("服务请求体")
  private String apiReq;

  @ApiModelProperty("服务返回体")
  private String apiResp;

  @ApiModelProperty("服务地址")
  private String apiUrl;

  @ApiModelProperty("服务创建时间")
  private Timestamp apiCtime;

  @ApiModelProperty("服务修改时间")
  private Timestamp apiMtime;

  @ApiModelProperty("创建者用户ID")
  private String apiUserId;

  @ApiModelProperty("建设单位")
  private String apiUnit;

  @ApiModelProperty("服务所属公司")
  private String ownerCompanyCode;

  @ApiModelProperty("服务所属公司")
  private String ownerCompanyName;

  @ApiModelProperty("所属区域 1:生产控制大区;2:信息关联大区;3:互联网大区")
  private long apiZone;

  @ApiModelProperty("'所属层级 1:应用层;2:平台层;3:网络层;4:感知层;")
  private long apiLayer;

  @ApiModelProperty("服务版本（最新版本）")
  private long apiVersion;

  public String getObjId() {
    return objId;
  }

  public void setObjId(String objId) {
    this.objId = objId;
  }

  public String getApiCode() {
    return apiCode;
  }

  public void setApiCode(String apiCode) {
    this.apiCode = apiCode;
  }

  public long getOperStatus() {
    return operStatus;
  }

  public void setOperStatus(long operStatus) {
    this.operStatus = operStatus;
  }

  public long getOperTarget() {
    return operTarget;
  }

  public void setOperTarget(long operTarget) {
    this.operTarget = operTarget;
  }

  public long getAuditType() {
    return auditType;
  }

  public void setAuditType(long auditType) {
    this.auditType = auditType;
  }

  public String getAuditMessage() {
    return auditMessage;
  }

  public void setAuditMessage(String auditMessage) {
    this.auditMessage = auditMessage;
  }

  public String getAuditJson() {
    return auditJson;
  }

  public void setAuditJson(String auditJson) {
    this.auditJson = auditJson;
  }

  public String getAuditUserId() {
    return auditUserId;
  }

  public void setAuditUserId(String auditUserId) {
    this.auditUserId = auditUserId;
  }

  public String getAuditUserName() {
    return auditUserName;
  }

  public void setAuditUserName(String auditUserName) {
    this.auditUserName = auditUserName;
  }

  public Timestamp getAuditCtime() {
    return auditCtime;
  }

  public void setAuditCtime(Timestamp auditCtime) {
    this.auditCtime = auditCtime;
  }

  public Timestamp getAuditMtime() {
    return auditMtime;
  }

  public void setAuditMtime(Timestamp auditMtime) {
    this.auditMtime = auditMtime;
  }

  public long getIsDelete() {
    return isDelete;
  }

  public void setIsDelete(long isDelete) {
    this.isDelete = isDelete;
  }

  public long getApplyVersion() {
    return applyVersion;
  }

  public void setApplyVersion(long applyVersion) {
    this.applyVersion = applyVersion;
  }

  public long getPreApiVersion() {
    return preApiVersion;
  }

  public void setPreApiVersion(long preApiVersion) {
    this.preApiVersion = preApiVersion;
  }

  public String getApiName() {
    return apiName;
  }

  public void setApiName(String apiName) {
    this.apiName = apiName;
  }

  public String getApiGroupCode() {
    return apiGroupCode;
  }

  public void setApiGroupCode(String apiGroupCode) {
    this.apiGroupCode = apiGroupCode;
  }

  public long getApiPromotion() {
    return apiPromotion;
  }

  public void setApiPromotion(long apiPromotion) {
    this.apiPromotion = apiPromotion;
  }

  public String getApiReq() {
    return apiReq;
  }

  public void setApiReq(String apiReq) {
    this.apiReq = apiReq;
  }

  public String getApiResp() {
    return apiResp;
  }

  public void setApiResp(String apiResp) {
    this.apiResp = apiResp;
  }

  public String getApiUrl() {
    return apiUrl;
  }

  public void setApiUrl(String apiUrl) {
    this.apiUrl = apiUrl;
  }

  public Timestamp getApiCtime() {
    return apiCtime;
  }

  public void setApiCtime(Timestamp apiCtime) {
    this.apiCtime = apiCtime;
  }

  public Timestamp getApiMtime() {
    return apiMtime;
  }

  public void setApiMtime(Timestamp apiMtime) {
    this.apiMtime = apiMtime;
  }

  public String getApiUserId() {
    return apiUserId;
  }

  public void setApiUserId(String apiUserId) {
    this.apiUserId = apiUserId;
  }

  public String getApiUnit() {
    return apiUnit;
  }

  public void setApiUnit(String apiUnit) {
    this.apiUnit = apiUnit;
  }

  public String getOwnerCompanyCode() {
    return ownerCompanyCode;
  }

  public void setOwnerCompanyCode(String ownerCompanyCode) {
    this.ownerCompanyCode = ownerCompanyCode;
  }

  public String getOwnerCompanyName() {
    return ownerCompanyName;
  }

  public void setOwnerCompanyName(String ownerCompanyName) {
    this.ownerCompanyName = ownerCompanyName;
  }

  public long getApiZone() {
    return apiZone;
  }

  public void setApiZone(long apiZone) {
    this.apiZone = apiZone;
  }

  public long getApiLayer() {
    return apiLayer;
  }

  public void setApiLayer(long apiLayer) {
    this.apiLayer = apiLayer;
  }

  public long getApiVersion() {
    return apiVersion;
  }

  public void setApiVersion(long apiVersion) {
    this.apiVersion = apiVersion;
  }
}
