package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.common.constants.CodeEnum;
import com.pms.ocp.mapper.ModelTypeMapper;
import com.pms.ocp.model.entity.ModelClassify;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ModelGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class ModelGroupServiceImpl implements ModelGroupService {

    @Autowired
    private ModelTypeMapper modelTypeMapper;

    /**
     * 获取模型类型
     * @return
     */
    @Override
    public ResponseVO getModelType() {
        QueryWrapper<ModelClassify> wrapper = new QueryWrapper<>();
        List<ModelClassify> modelClassifyList = modelTypeMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(modelClassifyList)){
            return ResponseVO.error("查询列表为空");
        }else{
            return ResponseVO.ok(modelClassifyList);
        }
    }

    @Override
    public ResponseVO createModelType(ModelClassify modelClassify) {
        int result = modelTypeMapper.insert(modelClassify);
        if(result>0){
            return ResponseVO.error(CodeEnum.SUCCESS);
        }else{
            return ResponseVO.ok(CodeEnum.INSERT_FAIL);
        }
    }

    @Override
    public ResponseVO deleteModelType(String modelTypeId) {
        int result = modelTypeMapper.deleteById(modelTypeId);
        if (result > 0) {
            return ResponseVO.error(CodeEnum.SUCCESS);
        } else {
            return ResponseVO.ok(CodeEnum.UNKNOWN);
        }
    }

    @Override
    public ResponseVO updateModelType(ModelClassify modelClassify) {
        int result = modelTypeMapper.updateById(modelClassify);
        if (result > 0) {
            return ResponseVO.error(CodeEnum.SUCCESS);
        } else {
            return ResponseVO.ok(CodeEnum.UP_DATA_FAIL);
        }
    }
}
