package com.pms.ocp.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.common.constants.AnalysisConstant;
import com.pms.ocp.common.constants.ExportUtils;
import com.pms.ocp.mapper.OcpApiTenantRelMapper;
import com.pms.ocp.mapper.OcpTenantAuditMapper;
import com.pms.ocp.model.entity.OcpApiTenantRel;
import com.pms.ocp.model.entity.OcpTenantAudit;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpTenantAuditService;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Service
public class OcpTenantAuditServiceImpl extends ServiceImpl<OcpTenantAuditMapper,OcpTenantAudit> implements OcpTenantAuditService {
    @Autowired
    private OcpTenantAuditMapper ocpTenantAuditMapper;

    @Autowired
    private OcpApiTenantRelMapper ocpApiTenantRelMapper;

    @Override
    public ResponseVO getOtaList(OcpTenantAudit ocpTenantAudit) {
        List<OcpTenantAudit> otaList = ocpTenantAuditMapper.getOtaList(ocpTenantAudit);
        return ResponseVO.ok(otaList);
    }

    @Override
    public ResponseVO getOtaListById(OcpTenantAudit ocpTenantAudit) {
        List<OcpTenantAudit> otaListById = ocpTenantAuditMapper.getOtaListById(ocpTenantAudit);
        return ResponseVO.ok(otaListById);
    }

    @Override
    public void exportExcel(OcpTenantAudit ocpTenantAudit, HttpServletRequest request, HttpServletResponse response) {
        List<OcpTenantAudit> otaListById = ocpTenantAuditMapper.getOtaListById(ocpTenantAudit);
        ExportParams param = new ExportParams(AnalysisConstant.exportOcpTenantApiName.OCP_TENANT_API,AnalysisConstant.exportOcpTenantApiName.OCP_TENANT_API);
        Workbook workbook = ExcelExportUtil.exportExcel(param, OcpTenantAudit.class,otaListById);
        ExportUtils.exportExcel(response, AnalysisConstant.exportOcpTenantApiName.OCP_TENANT_API,workbook);
    }

    @Override
    public ResponseVO OtaById(OcpTenantAudit ocpTenantAudit) {
        List<OcpTenantAudit> oatrList = ocpTenantAuditMapper.OtaById(ocpTenantAudit);
        return ResponseVO.ok(oatrList);
    }
}
