package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.pms.ocp.mapper.OcpTenantExtentMapper;
import com.pms.ocp.mapper.TenantBasicManagementMapper;
import com.pms.ocp.model.dto.OcpApiBaseDto;
import com.pms.ocp.model.dto.OcpTenantBaseDto;
import com.pms.ocp.model.entity.OcpApiExtent;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantExtent;
import com.pms.ocp.model.entity.OcpTenantSubs;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpTenantExtentService;
import com.pms.ocp.service.OcpTenantSubsService;
import com.pms.ocp.service.TenantBasicManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

@Service
public class TenantBasicManagementServiceImpl extends ServiceImpl<TenantBasicManagementMapper, OcpTenantBase> implements TenantBasicManagementService {
    @Autowired
    private TenantBasicManagementMapper tenantBasicManagementMapper;
    @Autowired
    private OcpTenantExtentMapper ocpTenantExtentMapper;
    @Autowired
    private OcpTenantSubsService ocpTenantSubsService;

    /**
     * 条件查询
     *
     * @param tenantCode
     * @param keyword
     * @param tenantUnit
     * @param startTime
     * @param endTime
     * @param pageSize
     * @param pageNum
     * @return
     */
    @Override
    public List<OcpTenantBaseDto> queryOcpTenantBaseDto(String tenantCode, String keyword, String tenantUnit, Timestamp startTime, Timestamp endTime, int pageSize, int pageNum) {
        pageSize = (pageSize - 1) * pageNum;
        return tenantBasicManagementMapper.queryOcpTenantBaseDto(keyword, tenantUnit, startTime, endTime, tenantCode, pageSize, pageNum);
    }

    /**
     * 应用发布  改变其应用状态
     *
     * @param tenantCodes 应用代码
     * @return
     */
    @Override
    public ResponseVO tenantIssue(String tenantCodes) {
        String[] split = tenantCodes.split(",");
        List<String> list = Arrays.asList(split);
        LambdaQueryWrapper<OcpTenantExtent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(OcpTenantExtent::getTenantCode, list);
        List<OcpTenantExtent> ocpTenantExtents = ocpTenantExtentMapper.selectList(lambdaQueryWrapper);
        for (OcpTenantExtent ocpTenantExtent : ocpTenantExtents) {
            if (ocpTenantExtent.getTenantState() == 1) {
                return ResponseVO.error("已发布");
            } else {
                ocpTenantExtent.setTenantState((short) 1);
                ocpTenantExtentMapper.updateById(ocpTenantExtent);
            }
        }
        return ResponseVO.ok();
    }

    /**
     * 应用订阅
     *
     * @param tenantCodes
     */
    @Override
    public void tenantLogin(String tenantCodes) {
        String[] split = tenantCodes.split(",");
        List<String> tenantCode = Arrays.asList(split);
        for (String s : tenantCode) {
            OcpTenantSubs ocpTenantSubs = new OcpTenantSubs();
            ocpTenantSubs.setTenantCode(s);
            ocpTenantSubs.setSubsCompanyCode(null);
            ocpTenantSubs.setSubsLogTenantAtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubs.setSubsLogTenantCtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubs.setSubsLogTenantMtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpTenantSubsService.save(ocpTenantSubs);
        }
    }

    /**
     * 应用下线
     *
     * @param tenantCodes
     */
    @Override
    public ResponseVO tenantCancel(String tenantCodes) {
        String[] split = tenantCodes.split(",");
        List<String> list = Arrays.asList(split);
        LambdaQueryWrapper<OcpTenantExtent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(OcpTenantExtent::getTenantCode, list);
        List<OcpTenantExtent> ocpTenantExtents = ocpTenantExtentMapper.selectList(lambdaQueryWrapper);
        for (OcpTenantExtent ocpTenantExtent : ocpTenantExtents) {
            if (ocpTenantExtent.getTenantState() == 2) {
                return ResponseVO.error("已下线");
            } else {
                ocpTenantExtent.setTenantState((short) 2);
                ocpTenantExtentMapper.updateById(ocpTenantExtent);
            }
        }
        return ResponseVO.ok();
    }

}
