package com.pms.ocp.common.utils;

import java.io.Serializable;
import java.net.InetAddress;

public abstract class UUIDGenerator {
    private static final int IP;
    private String separator = "";
    private static short counter = 0;
    private static final int JVM = (int) (System.currentTimeMillis() >>> 8);

    public UUIDGenerator() {
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    protected int getJVM() {
        return JVM;
    }

    protected short getCount() {
        Class var1 = UUIDGenerator.class;
        synchronized (UUIDGenerator.class) {
            if (counter < 0) {
                counter = 0;
            }

            short var10000 = counter;
            counter = (short) (var10000 + 1);
            return var10000;
        }
    }

    protected int getIP() {
        return IP;
    }

    protected short getHiTime() {
        return (short) ((int) (System.currentTimeMillis() >>> 32));
    }

    protected int getLoTime() {
        return (int) System.currentTimeMillis();
    }

    private static int toInt(byte[] bytes) {
        int result = 0;

        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }

        return result;
    }

    public abstract Serializable generate();

    static {
        int ipadd;
        try {
            ipadd = toInt(InetAddress.getLocalHost().getAddress());
        } catch (Exception var2) {
            ipadd = 0;
        }

        IP = ipadd;
    }
}
