package com.pms.ocp.common.utils;

import java.io.Serializable;

public class UUIDHexLengthGenerator extends UUIDGenerator {
    private int length = 32;
    private static int mycount = 0;

    public UUIDHexLengthGenerator() {
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    protected String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuffer buf = new StringBuffer("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    protected String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuffer buf = new StringBuffer("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    protected String random(int offset) {
        long curr = System.currentTimeMillis();
        String formatted = Long.toHexString((long) mycount + curr);
        StringBuffer buf = new StringBuffer();

        for (int i = offset; i < 0; ++i) {
            buf.append("0");
        }

        if (-offset < 8) {
            buf.replace(0, -offset, formatted.substring(formatted.length() + offset));
        } else if (-offset > 16) {
            buf.replace(0, 8, formatted.substring(formatted.length() - 8));
            formatted = Long.toHexString(curr + (long) mycount + (long) this.getCount());
            buf.replace(8, 16, formatted.substring(formatted.length() - 8));
        } else {
            buf.replace(0, 8, formatted.substring(formatted.length() - 8));
            formatted = Long.toHexString(curr + (long) mycount + (long) this.getCount() + curr / 10000L);
            buf.replace(8, -offset, formatted.substring(formatted.length() + offset + 8));
        }

        return buf.toString();
    }

    public Serializable generate() {
        ++mycount;
        StringBuffer sb = new StringBuffer(36);
        sb.append(this.format(this.getIP())).append(this.getSeparator()).append(this.format(this.getJVM())).append(this.getSeparator()).append(this.format(this.getHiTime())).append(this.getSeparator()).append(this.format(this.getLoTime())).append(this.getSeparator()).append(this.format(this.getCount())).toString();
        return this.processLength(sb);
    }

    private String processLength(StringBuffer sb) {
        if (this.getLength() != 32) {
            int offset = 32 - this.getLength();
            if (offset > 0) {
                sb.delete(0, offset);
            } else {
                sb.insert(0, this.getSeparator());
                sb.insert(0, this.random(offset));
            }
        }

        return sb.toString();
    }
}
