package com.pms.ocp.controller;



import com.pms.ocp.model.vo.ApiProvinceVo;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;

import com.pms.ocp.service.ApiProvinceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RequestMapping("/apiProvince")
@RestController
@Api(tags = "服务省侧接口")
public class ApiProvinceController {
    @Autowired
    private ApiProvinceService apiProvinceService;

    @ApiOperation("服务省侧-添加")
    @PostMapping("/create")
    public ResponseVO createApiBase(@RequestBody ApiProvinceVo apiProvinceVo) {
        boolean isSuccess =  apiProvinceService.updateOrCreate(apiProvinceVo);
        if(isSuccess){
            return ResponseVO.ok();
        }else {
            return ResponseVO.error("添加失败");
        }
    }

}
