package com.pms.ocp.controller;

import com.github.pagehelper.PageInfo;
import com.pms.ocp.common.utils.ExcelUtils;
import com.pms.ocp.common.utils.FileExport;
import com.pms.ocp.common.utils.FileUtil;
import com.pms.ocp.model.dto.ApiBaseDto;
import com.pms.ocp.model.dto.OcpGroupBaseDto;
import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.vo.OcpApiBaseVo;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.ApiBasicManagementService;
import com.pms.ocp.service.ApiDetailsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * @author guofanfan
 */
@Slf4j
@RequestMapping("/api/province")
@RestController
@Api(tags = "服务库省侧管理接口")
public class ApiProvinceTreeController {
    @Autowired
    private ApiDetailsService apiDetailsService;
    @Autowired
    private ApiBasicManagementService apiBasicManagementService;


    @ApiOperation("服务分类层级")
    @GetMapping("/apiBaseTreeOther")
    public ResponseVO<List<OcpGroupBaseDto>> apiBaseTreeOther(String apiGroupCompanyCode, String apiGroupCode, Integer apiGroupPromotionType,String apiCode) {
        List<OcpGroupBaseDto> apiTreeGroupDtos = apiBasicManagementService.apiBaseTreeOther(apiGroupCompanyCode, apiGroupCode, apiGroupPromotionType,apiCode);
        return ResponseVO.ok(apiTreeGroupDtos);
    }

    @ApiOperation("服务树列表")
    @GetMapping("/apiBaseTreeList")
    public ResponseVO<List<OcpApiBase>> apiBaseTreeList(String apiGroupCompanyCode, String apiGroupCode) {
        List<OcpApiBase> apiBaseList = apiBasicManagementService.apiBaseTreeApiList(apiGroupCompanyCode, apiGroupCode);
        return ResponseVO.ok(apiBaseList);
    }

    @ApiOperation("服务库服务详情-查询")
    @GetMapping("/query")
    public ResponseVO<OcpApiBaseVo> getApiDetails(String apiCode) {
        return apiDetailsService.getApiDetails(apiCode);
    }

}
