package com.pms.ocp.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pms.ocp.common.config.PageParam;
import com.pms.ocp.model.dto.ApiTreeGroupDto;
import com.pms.ocp.model.dto.OcpApiGroupDtos;
import com.pms.ocp.model.dto.PageGroupDto;
import com.pms.ocp.model.entity.OcpApiGroup;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.OcpApiTreeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhaochengming
 */


@Slf4j
@RequestMapping("/api-group/v1")
@RestController
@Api(tags = "服务树管理接口")
public class OcpApiTreeController {


    @Autowired
    private OcpApiTreeService service;

    /**
     * 服务树分类
     * @return
     */
    @GetMapping("/getTree")
    @ApiOperation("服务树分类")
    public ResponseVO< List<OcpApiGroup>> getTree(OcpApiGroup ocpApiGroup){
        List<OcpApiGroup> byGroup = service.getByGroup(ocpApiGroup.getApiGroupPromotionType(), ocpApiGroup.getApiGroupCode());
        return ResponseVO.ok(byGroup);
    }


    @PostMapping("/instertree")
    @ApiOperation("服务树分类--新增")
    public ResponseVO inseter(@RequestBody OcpApiGroup ocpApiGroup){
        OcpApiGroup ocpApiGroup1 = service.insertTree(ocpApiGroup);
            return ResponseVO.ok(ocpApiGroup1);

    }

    @GetMapping("/getone")
    @ApiOperation("服务树分类--分级数据")
    public ResponseVO<Page<OcpApiGroup>> getOne(PageGroupDto pageGroupDto){
        Page<OcpApiGroup> onePages = service.getOnePages(pageGroupDto);
        return ResponseVO.ok(onePages);
    }

    @PostMapping("/updatatree")
    @ApiOperation("服务树分类--修改")
    public ResponseVO updataTree(@RequestBody OcpApiGroup ocpApiGroup){
        boolean flag = service.updataOcpTree(ocpApiGroup);
        if (flag){
            return ResponseVO.ok();
        }
        return ResponseVO.error("您输入的服务编码重复，请重新输入");
    }
    @PostMapping("/deletetree")
    @ApiOperation("服务树分类--删除")
    public ResponseVO deleteTree(@RequestBody OcpApiGroup ocpApiGroup){
        boolean tree = service.deleteOcpTree(ocpApiGroup);
        if (tree){
            return ResponseVO.ok("删除成功！");
        }else {
            return ResponseVO.error("请先删除下级目录");
        }

    }


}
