package com.pms.ocp.model.dto;

import com.pms.ocp.model.entity.OcpTenantBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "应用信息图标储存表dto")
public class OcpBaseTiocnDto extends OcpTenantBase implements Serializable {

    /**
     * 图标种类tenant:应用图标api:服务图标
     */
    @ApiModelProperty(value = "图标种类——tenant:应用图标,api:服务图标")
    private String iocnType;

//    /**
//     * 编码值
//     */
//    @ApiModelProperty(value = "编码值")
//    private String codeNo;

    /**
     * 应用调用的服务数量图标数据
     */
    @ApiModelProperty(value = "应用调用的服务数量图标数据")
    private Object iocn;



    @ApiModelProperty(value = "服务编码字符串")
    private String apiCodes;

    public String getIocnType() {
        return iocnType;
    }

    public void setIocnType(String iocnType) {
        this.iocnType = iocnType;
    }

    public Object getIocn() {
        return iocn;
    }

    public void setIocn(Object iocn) {
        this.iocn = iocn;
    }



    public String getApiCodes() {
        return apiCodes;
    }

    public void setApiCodes(String apiCodes) {
        this.apiCodes = apiCodes;
    }
}
