package com.pms.ocp.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * 应用目录条件查询入参实体
 *
 * @author Administrator
 */
@ApiModel(value = "应用目录条件查询入参实体")
public class QueryAppDTO {

    @ApiModelProperty("当前页码")
    @NotNull(message = "当前页码不能为空")
    private Integer currentPage;

    @ApiModelProperty("页数目")
    @NotNull(message = "页数目不能为空")
    private Integer pageSize;

    @ApiModelProperty("所属专业")
    private String kind;

//    @ApiModelProperty("所属中心")
//    private String center;

    @ApiModelProperty("所属类别")
    private String type;

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getKind() {
        return kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

//    public String getCenter() {
//        return center;
//    }
//
//    public void setCenter(String center) {
//        this.center = center;
//    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }


}
