package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:40
 * @Description:模型属性对象
 */
@Data
@Accessors(chain = true)
@TableName("ocp_model_prop")
public class ModelProperty{

    /**
     * 模型属性编号
     */
    @TableId(value = "obj_id", type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 模型编号
     */
    private String modelCode;

    /**
     * 属性名称
     */
    private String columnName;

    /**
     * 属性编码
     */
    private String propCode;

    /**
     * 属性描述
     */
    private String columnComments;

    /**
     * 数据类型
     */
    private String dataType;

    /**
     * 数据长度
     */
    private Integer dataLength;

    /**
     * 数据精度
     */
    private Integer dataScale;

    /**
     * 是否主键
     */
    @TableField(value = "is_pk")
    private Integer boolPrimaryKey;

    /**
     * 是否必填
     */
    @TableField(value = "is_required")
    private Integer boolRequired;

    /**
     * 推广类型
     */
//    private String propPromotion;

    /**
     * 显示顺序
     */
    private Integer propOrderNo;

    /**
     * 提交人id
     */
    private String propUserId;

    /**
     * 提交人姓名
     */
    private String propUserName;

    /**
     * 创建时间
     */
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    @JsonSerialize(using = LocalDateTimeSerializer.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
//    @TableField()
//    @TableField(typeHandler = TimestampTypeHandler.class)
    private LocalDateTime propCtime;

    /**
     * 修改时间
     */
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
//    @TableField(typeHandler = TimestampTypeHandler.class)
    private LocalDateTime propMtime;

    /**
     * 表名称
     */
    @TableField(exist = false)
    private String modelTable;
}

