package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * @author Administrator
 */
@ApiModel(value = "com-pms-ocp-model-entity-OcpTenantIocn")
@Data
@TableName("ocp_tenant_iocn")
public class OcpTenantIocn implements Serializable {
    /**
     * 主键
     */
    @ApiModelProperty(value = "主键")
    @TableId(type = IdType.ASSIGN_ID)
    private String objId;

    /**
     * 图标种类tenant:应用图标api:服务图标
     */
    @ApiModelProperty(value = "图标种类——tenant:应用图标,api:服务图标")
    private String iocnType;

    /**
     * 编码值
     */
    @ApiModelProperty(value = "编码值")
    private String codeNo;

    /**
     * 应用调用的服务数量图标数据
     */
    @ApiModelProperty(value = "应用调用的服务数量图标数据")
    private Object iocn;

    /**
     * 所属公司可能会根据公司分区
     */
    @ApiModelProperty(value = "所属公司可能会根据公司分区")
    private String companyCode;

    private static final long serialVersionUID = 1L;

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getIocnType() {
        return iocnType;
    }

    public void setIocnType(String iocnType) {
        this.iocnType = iocnType;
    }

    public String getCodeNo() {
        return codeNo;
    }

    public void setCodeNo(String codeNo) {
        this.codeNo = codeNo;
    }

    public Object getIocn() {
        return iocn;
    }

    public void setIocn(Object iocn) {
        this.iocn = iocn;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }
}

