package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * 应用订阅记录表
 * @TableName ocp_tenant_subs
 */
@Data
@Accessors(chain = true)
@TableName("ocp_tenant_subs")
@ApiModel("应用订阅记录表1")
public class OcpTenantSubs implements Serializable {

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("关系ID")
    private String objId;


    @ApiModelProperty("服务编码")
    private String tenantCode;


    @ApiModelProperty("订阅公司编码")
    private String subsCompanyCode;


    @ApiModelProperty("服务订阅创建时间")
    private Timestamp subsLogTenantCtime;


    @ApiModelProperty("服务订阅修改时间")
    private Timestamp subsLogTenantMtime;


    @ApiModelProperty("服务订阅创建用户ID")
    private String subsLogTenantUserId;


    @ApiModelProperty("服务订阅添加时间")
    private Timestamp subsLogTenantAtime;


    @ApiModelProperty("是否删除0-否，1-是")
    private Short isDelete;


    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getSubsCompanyCode() {
        return subsCompanyCode;
    }

    public void setSubsCompanyCode(String subsCompanyCode) {
        this.subsCompanyCode = subsCompanyCode;
    }

    public Timestamp getSubsLogTenantCtime() {
        return subsLogTenantCtime;
    }

    public void setSubsLogTenantCtime(Timestamp subsLogTenantCtime) {
        this.subsLogTenantCtime = subsLogTenantCtime;
    }

    public Timestamp getSubsLogTenantMtime() {
        return subsLogTenantMtime;
    }

    public void setSubsLogTenantMtime(Timestamp subsLogTenantMtime) {
        this.subsLogTenantMtime = subsLogTenantMtime;
    }

    public String getSubsLogTenantUserId() {
        return subsLogTenantUserId;
    }

    public void setSubsLogTenantUserId(String subsLogTenantUserId) {
        this.subsLogTenantUserId = subsLogTenantUserId;
    }

    public Timestamp getSubsLogTenantAtime() {
        return subsLogTenantAtime;
    }

    public void setSubsLogTenantAtime(Timestamp subsLogTenantAtime) {
        this.subsLogTenantAtime = subsLogTenantAtime;
    }

    public Short getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Short isDelete) {
        this.isDelete = isDelete;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        OcpTenantSubs other = (OcpTenantSubs) that;
        return (this.getObjId() == null ? other.getObjId() == null : this.getObjId().equals(other.getObjId()))
            && (this.getTenantCode() == null ? other.getTenantCode() == null : this.getTenantCode().equals(other.getTenantCode()))
            && (this.getSubsCompanyCode() == null ? other.getSubsCompanyCode() == null : this.getSubsCompanyCode().equals(other.getSubsCompanyCode()))
            && (this.getSubsLogTenantCtime() == null ? other.getSubsLogTenantCtime() == null : this.getSubsLogTenantCtime().equals(other.getSubsLogTenantCtime()))
            && (this.getSubsLogTenantMtime() == null ? other.getSubsLogTenantMtime() == null : this.getSubsLogTenantMtime().equals(other.getSubsLogTenantMtime()))
            && (this.getSubsLogTenantUserId() == null ? other.getSubsLogTenantUserId() == null : this.getSubsLogTenantUserId().equals(other.getSubsLogTenantUserId()))
            && (this.getSubsLogTenantAtime() == null ? other.getSubsLogTenantAtime() == null : this.getSubsLogTenantAtime().equals(other.getSubsLogTenantAtime()))
            && (this.getIsDelete() == null ? other.getIsDelete() == null : this.getIsDelete().equals(other.getIsDelete()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getObjId() == null) ? 0 : getObjId().hashCode());
        result = prime * result + ((getTenantCode() == null) ? 0 : getTenantCode().hashCode());
        result = prime * result + ((getSubsCompanyCode() == null) ? 0 : getSubsCompanyCode().hashCode());
        result = prime * result + ((getSubsLogTenantCtime() == null) ? 0 : getSubsLogTenantCtime().hashCode());
        result = prime * result + ((getSubsLogTenantMtime() == null) ? 0 : getSubsLogTenantMtime().hashCode());
        result = prime * result + ((getSubsLogTenantUserId() == null) ? 0 : getSubsLogTenantUserId().hashCode());
        result = prime * result + ((getSubsLogTenantAtime() == null) ? 0 : getSubsLogTenantAtime().hashCode());
        result = prime * result + ((getIsDelete() == null) ? 0 : getIsDelete().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", objId=").append(objId);
        sb.append(", tenantCode=").append(tenantCode);
        sb.append(", subsCompanyCode=").append(subsCompanyCode);
        sb.append(", subsLogTenantCtime=").append(subsLogTenantCtime);
        sb.append(", subsLogTenantMtime=").append(subsLogTenantMtime);
        sb.append(", subsLogTenantUserId=").append(subsLogTenantUserId);
        sb.append(", subsLogTenantAtime=").append(subsLogTenantAtime);
        sb.append(", isDelete=").append(isDelete);
        sb.append("]");
        return sb.toString();
    }
}