package com.pms.ocp.model.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 服务表(PmsZyApi)实体类
 *
 * @author wangsufu
 * @since 2022-01-04 20:46:09
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName("pms_company")
@ApiModel(value = "PMS网省公司表", description = "PMS网省公司表")
public class PmsCompany implements Serializable {
    private static final long serialVersionUID = -79779908395545838L;

    @ApiModelProperty(value = "id")
    private Integer id;

    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "公司代码")
    private String companyCode;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "公司名称简写")
    private String companyShortName;

    @ApiModelProperty(value = "公司层级")
    private String companyLevel;

    @ApiModelProperty(value = "公司排序")
    private Integer companySort;


}

