package com.pms.ocp.model.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:40
 * @Description:模型属性VO对象
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "模型属性VO对象")
public class ModelPropertyVO {

    /**
     * 模型属性编号
     */
    @ApiModelProperty(value = "模型属性编号")
    private String objId;

    /**
     * 模型编号
     */
    @ApiModelProperty(value = "模型编号")
    private String modelCode;

    /**
     * 模型表名称
     */
    @ApiModelProperty(value = "模型表名称")
    private String modelTableName;

    /**
     * 属性名称
     */
    @ApiModelProperty(value = "属性名称")
    private String columnName;

    /**
     * 属性编码
     */
    @ApiModelProperty(value = "属性编码")
    private String propCode;

    /**
     * 数据类型
     */
    @ApiModelProperty(value = "数据类型")
    private String dataType;

    /**
     * 数据长度
     */
    @ApiModelProperty(value = "数据长度")
    private Integer dataLength;

    /**
     * 数据精度
     */
    @ApiModelProperty(value = "数据精度")
    private Integer dataScale;

    /**
     * 是否主键
     */
    @ApiModelProperty(value = "是否主键")
    @TableField("is_pk")
    private Integer boolPrimaryKey;

    /**
     * 显示顺序
     */
//    private Integer propOrderNo;

    /**
     * 提交人id
     */
//    private String propUserId;

    /**
     * 提交人姓名
     */
//    private String propUserName;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "模型关系编号")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime propCtime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "模型关系编号")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime propMtime;
}
