package com.pms.ocp.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.pms.ocp.model.entity.OcpApiParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author guofanfan
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "服务列表信息vo")
public class OcpApiBaseVo implements Serializable {
    @ApiModelProperty(value = "序号")
    @Excel(name = "序号")
    private String objId;
    @ApiModelProperty(value = "服务编码")
    @Excel(name = "服务编码")
    private String apiCode;
    @ApiModelProperty(value = "服务中文名称")
    @Excel(name = "服务中文名称")
    private String apiName;
    @ApiModelProperty(value = "所属集群")
    @Excel(name = "所属集群")
    private String clusterName;
    @ApiModelProperty(value = "所属命名空间")
    @Excel(name = "所属命名空间")
    private String spaceName;
    @ApiModelProperty(value = "接口URL")
    @Excel(name = "接口URL")
    private String apiUrl;
    @ApiModelProperty(value = "状态")
    @Excel(name = "状态")
    private String apiState;
    @ApiModelProperty(value = "注册时间")
    @Excel(name = "注册时间")
    private Timestamp apiCtime;
    @ApiModelProperty(value = "建设单位")
    @Excel(name = "建设单位")
    private String apiUnit;
    @ApiModelProperty(value = "出参入参")
    @Excel(name = "建设单位")
    private List<OcpApiParam> apiParams;

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getApiCode() {
        return apiCode;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getClusterName() {
        return clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getSpaceName() {
        return spaceName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiState() {
        return apiState;
    }

    public void setApiState(String apiState) {
        this.apiState = apiState;
    }

    public Timestamp getApiCtime() {
        return apiCtime;
    }

    public void setApiCtime(Timestamp apiCtime) {
        this.apiCtime = apiCtime;
    }

    public String getApiUnit() {
        return apiUnit;
    }

    public void setApiUnit(String apiUnit) {
        this.apiUnit = apiUnit;
    }

    public List<OcpApiParam> getApiParams() {
        return apiParams;
    }

    public void setApiParams(List<OcpApiParam> apiParams) {
        this.apiParams = apiParams;
    }
}

