package com.pms.ocp.service;

import com.github.pagehelper.PageInfo;
import com.pms.ocp.model.dto.ModelPropertyDTO;
import com.pms.ocp.model.entity.ModelProperty;
import com.pms.ocp.model.vo.ModelPropertyVO;

import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/2/22 16:03
 * @Description:模型属性业务层接口
 */
public interface ModelPropertyService {

    /**
     * 创建模型属性
     *
     * @param modelPropertyDTO
     * @return
     */
    Integer createModelProperty(ModelPropertyDTO modelPropertyDTO);

    /**
     * 删除模型属性
     *
     * @param modelCode
     * @return
     */
    Integer deleteModelProperty(String modelCode, String propCode);

    /**
     * 批量删除模型属性
     *
     * @param ids
     * @return
     */
    Integer deleteBatchModelProperty(List<String> ids);

    /**
     * 更新模型属性
     *
     * @param modelPropertyDTO
     * @return
     */
    Integer updateModelProperty(ModelPropertyDTO modelPropertyDTO);

    /**
     * 获取模型属性列表
     *
     * @param
     * @return
     */
    List<ModelProperty> listModelProperty(String objId, String modelCode, String propCode);

    /**
     * 获取封装之后的模型属性列表
     *
     * @param
     * @return
     */
    List<ModelPropertyVO> listModelPropertyVO(Integer currentPage, Integer pageSize,
                                              String modelCode, String ownerCompanyCode, String modelGroupCode);

    /**
     * 获取模型属性
     *
     * @param
     * @return
     */
    ModelPropertyDTO getModelProperty();
}
