package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import com.pms.ocp.mapper.ApiBasicManagementMapper;
import com.pms.ocp.mapper.OcpApiExtentMapper;
import com.pms.ocp.mapper.OcpApiGroupMapper;
import com.pms.ocp.mapper.OcpApiSubsMapper;

import com.pms.ocp.model.dto.ApiBaseDto;

import com.pms.ocp.model.dto.OcpGroupBaseDto;

import com.pms.ocp.model.entity.OcpApiBase;
import com.pms.ocp.model.entity.OcpApiExtent;
import com.pms.ocp.model.entity.OcpApiGroup;
import com.pms.ocp.model.entity.OcpApiSubs;
import com.pms.ocp.model.vo.*;

import com.pms.ocp.service.ApiBasicManagementService;
import com.pms.ocp.service.OcpApiExtentService;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.time.LocalDateTime;

import java.util.ArrayList;
import java.util.Arrays;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiBasicManagementServiceImpl extends ServiceImpl<ApiBasicManagementMapper, OcpApiBase>
        implements ApiBasicManagementService {
    @Autowired
    private ApiBasicManagementMapper apiBasicManagementMapper;
    @Autowired
    private OcpApiSubsMapper ocpApiSubsMapper;
    @Autowired
    private OcpApiExtentService ocpApiExtentService;
    @Autowired
    private OcpApiExtentMapper ocpApiExtentMapper;
    @Autowired
    private OcpApiGroupMapper ocpApiGroupMapper;

    List<String> apiGroupCode = new ArrayList<>();

    /**
     * 导出查询
     *
     * @param apiCodes
     * @return
     */
    public List<OcpApiBaseVo> selectApiExport(String apiCodes) {
        String[] split = apiCodes.split(",");
        List<String> list = Arrays.asList(split);
        return apiBasicManagementMapper.selectApiExport(list);

    }

    /**
     * 服务注册
     *
     * @param ocpApiBase
     */
    public void addOcpApiBase(OcpApiBase ocpApiBase) {
        apiBasicManagementMapper.insert(ocpApiBase);
    }

    /**
     * 服务订阅
     *
     * @param apiCodes
     */
    public void apiLogin(String apiCodes) {
        String[] split = apiCodes.split(",");
        List<String> apiCode = Arrays.asList(split);
        for (String s : apiCode) {
            OcpApiSubs ocpApiSubs = new OcpApiSubs();
            ocpApiSubs.setApiCode(s);
            ocpApiSubs.setSubsLogApiCtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpApiSubs.setSubsLogApiMtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpApiSubs.setSubsLogApiUserId(null);
            ocpApiSubs.setSubsLogApiAtime(Timestamp.valueOf(LocalDateTime.now()));
            ocpApiSubs.setSubsCompanyCode(null);
            ocpApiSubsMapper.insert(ocpApiSubs);
        }
    }

    /**
     * 条件查询
     *
     * @param apiCode
     * @param keyword
     * @param apiUnit
     * @param startTime
     * @param endTime
     * @return
     */
    @Override
    public List<OcpApiBaseVo> queryOcpApiBaseDto(String apiCode, String keyword, String apiUnit, Timestamp startTime, Timestamp endTime, int pageSize, int pageNum) {
        pageSize = (pageSize - 1) * pageNum;
        return apiBasicManagementMapper.queryOcpApiBaseDto(keyword, apiUnit, startTime, endTime, apiCode, pageSize, pageNum);
    }

    /**
     * 导入添加到数据库
     *
     * @param personList
     */
    public void apiImport(List<OcpApiBaseVo> personList) {
        for (OcpApiBaseVo ocpApiBaseVo : personList) {
            String apiCode = ocpApiBaseVo.getApiCode();
            Timestamp apiCtime = ocpApiBaseVo.getApiCtime();
            String apiName = ocpApiBaseVo.getApiName();
            String apiUnit = ocpApiBaseVo.getApiUnit();
            String apiUrl = ocpApiBaseVo.getApiUrl();
            String apiState = ocpApiBaseVo.getApiState();
            String spaceName = ocpApiBaseVo.getSpaceName();
            String clusterName = ocpApiBaseVo.getClusterName();
            OcpApiBase ocpApiBase = new OcpApiBase();
            ocpApiBase.setApiCode(apiCode);
            ocpApiBase.setApiGroupCode("1");
            ocpApiBase.setApiCtime(apiCtime);
            ocpApiBase.setApiName(apiName);
            ocpApiBase.setApiUnit(apiUnit);
            ocpApiBase.setApiUrl(apiUrl);
            this.save(ocpApiBase);
            OcpApiExtent ocpApiExtent = new OcpApiExtent();
            ocpApiExtent.setApiCode(apiCode);
            ocpApiExtent.setApiState(apiState);
            ocpApiExtent.setSpaceName(spaceName);
            ocpApiExtent.setClusterName(clusterName);
            ocpApiExtentService.save(ocpApiExtent);

        }
    }

    /**
     * 服务发布
     *
     * @param apiCodes
     */
    public ResponseVO apiIssue(String apiCodes) {
        String[] split = apiCodes.split(",");
        List<String> list = Arrays.asList(split);
        LambdaQueryWrapper<OcpApiExtent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(OcpApiExtent::getApiCode, list);
        List<OcpApiExtent> ocpApiExtents = ocpApiExtentMapper.selectList(lambdaQueryWrapper);
        for (OcpApiExtent ocpApiExtent : ocpApiExtents) {
            if (ocpApiExtent.getApiState().equals("1")) {
                return ResponseVO.error("已发布");
            } else {
                ocpApiExtent.setApiState("1");
                ocpApiExtentMapper.updateById(ocpApiExtent);
            }
        }
        return ResponseVO.ok();
    }

    @Override
    public List<OcpApiGroup> apiBaseTree(String apiGroupCompanyCode) {
        List<OcpApiGroup> ocpApiGroups = ocpApiGroupMapper.selectTreeList(apiGroupCompanyCode);
        return ocpApiGroups;
    }

    @Override
    public List<OcpGroupBaseDto> apiBaseTreeOther(String apiGroupCompanyCode, String apiGroupPcode, Integer apiGroupPromotionType, String apiCode) {
        List<OcpGroupBaseDto> ocpApiGroups = ocpApiGroupMapper.apiTree(apiGroupCompanyCode, apiGroupPcode, apiGroupPromotionType);
        if (ocpApiGroups.size() != 0) {
            return ocpApiGroups;
        } else {
            if (StringUtils.isNotEmpty(apiCode)) {
                return Collections.EMPTY_LIST;
            } else {
                List<OcpGroupBaseDto> ocpGroupBaseDto = ocpApiGroupMapper.selectBase(apiGroupCompanyCode, apiGroupPcode, apiGroupPromotionType);
                if (ocpGroupBaseDto.size() != 0) {
                    return ocpGroupBaseDto;
                }
                return Collections.EMPTY_LIST;
            }
        }

    }

    @Override
    public ResponseVO<PageInfo<OcpApiBaseVo>> getBaseByGroupCode(ApiBaseDto apiBaseReq) {
        if (apiBaseReq.getPageNum() == null || apiBaseReq.getPageSize() == null) {
            return ResponseVO.error("分页参数不能为空");
        }
        apiGroupCode.add(apiBaseReq.getApiGroupCode());
        setGroupIdValue(apiBaseReq.getApiGroupCompanyCode(), apiBaseReq.getApiGroupCode(), apiBaseReq.getApiPromotion());
        PageHelper.startPage(apiBaseReq.getPageNum(), apiBaseReq.getPageSize());
        apiBaseReq.setApiGroupCodeList(apiGroupCode);
        List<OcpApiBaseVo> ocpApiBaseVos = ocpApiGroupMapper.selectPageLists(apiBaseReq);
        apiGroupCode.clear();
        PageInfo<OcpApiBaseVo> pageInfo = new PageInfo<>(ocpApiBaseVos);
        return ResponseVO.ok(pageInfo);
    }

    @Override
    public List<OcpApiBase> apiBaseTreeApiList(String apiGroupCompanyCode, String apiGroupPcode) {
        QueryWrapper qw = new QueryWrapper();
        if (!StringUtils.isEmpty(apiGroupPcode)) {
            qw.eq("api_group_code", apiGroupPcode);
        }
        if (!StringUtils.isEmpty(apiGroupCompanyCode)) {
            qw.eq("owner_company_code", apiGroupCompanyCode);
        }

        return apiBasicManagementMapper.selectList(qw);
    }

//    /**
//     * 服务列表2
//     * @param wholeLinkParamDto
//     * @return
//     */
//    @Override
//    public ResponseVO queryApiTreeData(WholeLinkParamDto wholeLinkParamDto) {
//        List<WholeLinkTreeVo> apiTreeDataList = ocpApiGroupMapper.queryApiTreeData1();
//        List<Menu> list = new ArrayList<>();
//        for (WholeLinkTreeVo wholeLinkTreeVo : apiTreeDataList) {
//            Menu menu = new Menu();
//            menu.setId(wholeLinkTreeVo.getApiGroupCode());
//            menu.setParentId(wholeLinkTreeVo.getApiGroupPcode());
//            menu.setText(wholeLinkTreeVo.getApiGroupName());
//            menu.setType(wholeLinkTreeVo.getApiGroupPromotionType());
//            list.add(menu);
//        }
//        MenuTree menuTree = new MenuTree(list);
//        list = menuTree.builTree();
//        return ResponseVO.ok(list);
//    }

    /**
     * 分组权限分组使用in查询
     *
     * @param
     * @param
     */
    private void setGroupIdValue(String apiGroupCompanyCode, String code, Integer apiGroupPromotionType) {
        List<String> codes = getIdsByPIdPub(apiGroupCompanyCode, code, apiGroupPromotionType);
        if (codes.size() > 0) {
            for (String cod : codes) {
                setGroupIdValue(apiGroupCompanyCode, cod, apiGroupPromotionType);
                apiGroupCode.add(cod);
            }
            ;
        }
    }

    /**
     * pcode服务分组
     *
     * @param apiGroupCompanyCode
     * @param code
     * @return
     */
    public List<String> getIdsByPIdPub(String apiGroupCompanyCode, String code, Integer apiGroupPromotionType) {
        List<OcpApiGroup> ocpApiGroups = ocpApiGroupMapper.apiBaseTreeOther(apiGroupCompanyCode, code, apiGroupPromotionType);
        return ocpApiGroups.stream().map(OcpApiGroup::getApiGroupCode).collect(Collectors.toList());
    }

    /**
     * 编辑中的模糊查询
     *
     * @param apiCode
     * @param apiName
     * @param apiCenterCode
     * @return
     */
    @Override
    public ResponseVO<PageInfo<OcpApiBase>> selectByCondition(String apiCode, String apiName, String apiCenterCode, Integer pageNum, Integer pageSize) {
        if (pageNum == null || pageSize == null) {
            return ResponseVO.error("分页参数不能为空");
        }

        PageHelper.startPage(pageNum, pageSize);
        List<OcpApiBase> list = apiBasicManagementMapper.selectByCondition(apiCode, apiName, apiCenterCode);
        PageInfo<OcpApiBase> pageInfo = new PageInfo<>(list);
        return ResponseVO.ok(pageInfo);
    }
}
