package com.pms.ocp.service.impl;

import com.pms.ocp.common.utils.GUIDGenerator;
import com.pms.ocp.common.utils.PageUtil;
import com.pms.ocp.mapper.*;
import com.pms.ocp.model.dto.AppRegisterDTO;
import com.pms.ocp.model.dto.ImgDTO;
import com.pms.ocp.model.dto.QueryAppDTO;
import com.pms.ocp.model.entity.OcpTenantBase;
import com.pms.ocp.model.entity.OcpTenantExtent;
import com.pms.ocp.model.entity.OcpTenantGroup;
import com.pms.ocp.model.entity.OcpTenantIocn;
import com.pms.ocp.model.vo.QueryAppInfoVO;
import com.pms.ocp.model.vo.ResponseVO;
import com.pms.ocp.service.AppRegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 应用注册业务接口实现
 *
 * @author Administrator
 */
@Service
public class AppRegisterServiceImpl implements AppRegisterService {
    @Autowired
    private AppRegisterMapper appRegisterMapper;

    @Autowired
    private OcpTenantIocnMapper ocpTenantIocnMapper;

    @Autowired
    private OcpTenantBaseMapper ocpTenantBaseMapper;

    @Autowired
    private OcpTenantExtentMapper ocpTenantExtentMapper;

    @Autowired
    private OcpTenantGroupMapper ocpTenantGroupMapper;

    @Override
    public ResponseVO addApp(AppRegisterDTO appRegisterDTO) {

        OcpTenantIocn ocpTenantIocn = new OcpTenantIocn();
        ocpTenantIocn.setIocnType("tenant");
        ocpTenantIocn.setCodeNo(appRegisterDTO.getAppCode());
        ocpTenantIocn.setIocn(appRegisterDTO.getImgUrl());
        // 加字段

        int n = ocpTenantIocnMapper.insert(ocpTenantIocn);


        OcpTenantExtent ocpTenantExtent = new OcpTenantExtent();
        ocpTenantExtent.setTenantCtime(new Date());
        ocpTenantExtent.setTenantCode(appRegisterDTO.getAppCode());
        ocpTenantExtent.setClusterName(appRegisterDTO.getGroup());
        ocpTenantExtent.setDeploymentName(appRegisterDTO.getDeploymentName());
        int j = ocpTenantExtentMapper.insert(ocpTenantExtent);


        OcpTenantGroup ocpTenantGroup = new OcpTenantGroup();
        ocpTenantGroup.setTenantGroupUserId(appRegisterDTO.getUserId());
        ocpTenantGroup.setTenantGroupUserName(appRegisterDTO.getUserName());
        ocpTenantGroup.setTenantGroupCtime(new Timestamp(System.currentTimeMillis()));
        ocpTenantGroup.setTenantGroupCode(GUIDGenerator.generate32(true));
        ocpTenantGroup.setTenantGroupName(appRegisterDTO.getType());
        int m = ocpTenantGroupMapper.insert(ocpTenantGroup);


        OcpTenantBase ocpTenantBase = new OcpTenantBase();
        ocpTenantBase.setTenantUserId(appRegisterDTO.getUserId());
        ocpTenantBase.setTenantName(appRegisterDTO.getAppName());
        ocpTenantBase.setTenantCode(appRegisterDTO.getAppCode());
        ocpTenantBase.setProfessionalKind(appRegisterDTO.getKind());
        ocpTenantBase.setTenantUrl(appRegisterDTO.getUrl());
        ocpTenantBase.setTenantDescription(appRegisterDTO.getDesc());
        ocpTenantBase.setTenantUnit(appRegisterDTO.getManufacturer());
        ocpTenantBase.setTenantVersion(appRegisterDTO.getVersion());
        ocpTenantBase.setTenantCtime(new Timestamp(System.currentTimeMillis()));
        ocpTenantBase.setTenantGroupCode(ocpTenantGroup.getTenantGroupCode());
        int i = ocpTenantBaseMapper.insert(ocpTenantBase);


        if (n > 0 && i > 0 && j > 0 && m > 0) {
            return ResponseVO.ok();
        }
        return ResponseVO.error("新增应用注册失败");
    }

    @Override
    public ResponseVO getAppInfo(QueryAppDTO queryAppDTO) {
        List<QueryAppInfoVO> list = appRegisterMapper.getAppInfo(queryAppDTO);
        PageUtil<QueryAppInfoVO> pageUtil = new PageUtil<>();
        pageUtil.startPage(queryAppDTO.getCurrentPage(), queryAppDTO.getPageSize(), list);
        return ResponseVO.ok(pageUtil);
    }

    @Override
    public ResponseVO addAppImgUrl(List<ImgDTO> imgDTO) {
        List<OcpTenantIocn> list = new ArrayList<>();

        for (ImgDTO item : imgDTO) {
            OcpTenantIocn ocpTenantIocn = new OcpTenantIocn();
            ocpTenantIocn.setIocnType("tenant");
            ocpTenantIocn.setCodeNo(item.getCodeNo());
            ocpTenantIocn.setIocn(item.getImg());
            list.add(ocpTenantIocn);
        }
        int count = appRegisterMapper.batchInsert(list);
        if (count > 0) {
            return ResponseVO.ok();
        }
        return ResponseVO.error("应用预览图插入失败");
    }
}
