package com.pms.ocp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pms.ocp.mapper.ModelRelationMapper;
import com.pms.ocp.model.dto.ModelRelationDTO;
import com.pms.ocp.model.entity.ModelRelation;
import com.pms.ocp.model.vo.ModelRelationVO;
import com.pms.ocp.service.ModelRelationService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Auther: wangjian
 * @Date: 2022/3/10 19:34
 * @Description:
 */

@Service
public class ModelRelationServiceImpl implements ModelRelationService {

    @Autowired
    private ModelRelationMapper modelRelationMapper;

    @Override
    public Integer createModelRelation(ModelRelationDTO modelRelationDTO) {

        ModelRelation modelRelation = new ModelRelation();

        BeanUtils.copyProperties(modelRelationDTO, modelRelation);

        modelRelation.setModelCtime(LocalDateTime.now());

        return modelRelationMapper.insert(modelRelation);
    }

    @Override
    public Integer deleteModelRelation(String objId, String modelCode) {

        QueryWrapper<ModelRelation> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelRelation::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelRelation::getModelCode, modelCode);
        }

        return modelRelationMapper.delete(queryWrapper);
    }

    @Override
    public Integer deleteBatchModelRelation(List<String> ids) {
        return modelRelationMapper.deleteBatchIds(ids);
    }

    @Override
    public Integer updateModelRelation(ModelRelation modelRelation) {
        return null;
    }

    @Override
    public List<ModelRelation> getModelRelationList(String objId, String modelGroupCode, String modelCode) {
        QueryWrapper<ModelRelation> queryWrapper = new QueryWrapper();

        if (StringUtils.isNotEmpty(objId)) {
            queryWrapper.lambda().eq(ModelRelation::getObjId, objId);
        }

        if (StringUtils.isNotEmpty(modelGroupCode)) {
            queryWrapper.lambda().eq(ModelRelation::getModelPropCode, modelGroupCode);
        }

        if (StringUtils.isNotEmpty(modelCode)) {
            queryWrapper.lambda().eq(ModelRelation::getModelCode, modelCode);
        }

        return modelRelationMapper.selectList(queryWrapper);
    }

    @Override
    public ModelRelationVO getModelRelation(String modelId) {
        return null;
    }
}
