package com.pms.ocp.common.aspectj;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.pms.ocp.model.entity.ModelAudit;
import com.pms.ocp.service.ModelAuditService;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.time.LocalDateTime;

/**
 * @Auther: wangjian
 * @Date: 2022/3/8 17:21
 * @Description:
 */

@Aspect
@Component
public class OperLogAspect {

    @Autowired
    private ModelAuditService modelAuditService;

    private static Logger logger = LoggerFactory.getLogger(OperLogAspect.class);

    @Pointcut("@annotation(com.pms.ocp.common.aspectj.OperLog)")
    public void logPointCut() {
    }

    @Around("logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        System.out.println("日志");
        //执行方法
        Object result = point.proceed();
        //执行时长
        long time = System.currentTimeMillis() - beginTime;

        //保存日志
        saveSysLog(point, time, result);

        return result;
    }

    private void saveSysLog(ProceedingJoinPoint point, long time, Object obj) {
        MethodSignature signature = (MethodSignature) point.getSignature();
        Method method = signature.getMethod();
        ModelAudit modelAudit = new ModelAudit();
        OperLog operLog = method.getAnnotation(OperLog.class);
        if (operLog != null) {
            String content = operLog.value();
            modelAudit.setAuditType(operLog.auditType());
            modelAudit.setAuditMessageJson(content);
        }
        //请求的方法名
//        String className = point.getTarget().getClass().getName();
        String methodName = signature.getName();
//        dto.setMethod(className + "." + methodName + "()");
        //设置操作类型
        if (modelAudit.getAuditType() == 3) {
            modelAudit.setOperStatus(getOperateType(methodName, operLog.operStatus()));
        }
        //获取request
        HttpServletRequest request = getHttpServletRequest();
        //请求的参数
        modelAudit.setAuditMessageJson(getRequestParams(request, point));
//        //设置ip地址
//        dto.setIp(getIpAddr(request));
        //获取用户登录信息
//        TODO
//        TUser user = (TUser) SecurityUtils.getSubject().getPrincipal();
//        if (user != null) {
//            modelNote.setUserid(user.getUserName());
//            modelNote.setUsername(user.getPassWord());
//        }
//        modelNote.setCostTime(time);
        modelAudit.setAuditCtime(LocalDateTime.now());

        modelAuditService.createModelNote(modelAudit);
    }

    private int getOperateType(String methodName, int operateType) {
        if (operateType >= 0) {
            return operateType;
        }
        if (methodName.startsWith("create")) {
            return 1;
        }
        if (methodName.startsWith("update")) {
            return 2;
        }
        return 2;
    }

    private HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

    private String getRequestParams(HttpServletRequest request, JoinPoint joinPoint) {
        String httpMethod = request.getMethod();
        String param = "";
        if ("POST".equals(httpMethod) || "PUT".equals(httpMethod) || "PATCH".equals(httpMethod)) {
            Object[] paramArray = joinPoint.getArgs();
            Object[] arguments = new Object[paramArray.length];
            for (int i = 0; i < paramArray.length; i++) {
                if (paramArray[i] instanceof BindingResult || paramArray[i] instanceof ServletRequest || paramArray[i] instanceof ServletResponse || paramArray[i] instanceof MultipartFile) {
                    continue;
                }
                arguments[i] = paramArray[i];
            }
            PropertyFilter propertyFilter = new PropertyFilter() {
                @Override
                public boolean apply(Object object, String name, Object value) {
                    if (value != null && value.toString().length() > 500) {
                        return false;
                    }
                    return true;
                }
            };
            param = JSONObject.toJSONString(arguments, propertyFilter);
        } else {
            MethodSignature signature = (MethodSignature) joinPoint.getSignature();
            Method method = signature.getMethod();
            //请求的方法参数值
            Object[] args = joinPoint.getArgs();
            //请求的方法名称
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            String[] parameterNames = u.getParameterNames(method);
            if (args != null && parameterNames != null) {
                for (int i = 0; i < args.length; i++) {
                    param += " " + parameterNames[i] + ": " + args[i];
                }
            }
        }
        return param;
    }

    public String getIpAddr(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            if (StringUtils.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty(ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT-IP");
            }
            if (StringUtils.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X-FORWARDED-FOR");
            }
            if (StringUtils.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        } catch (Exception e) {
            logger.error("IP error", e);
        }
        return ip;
    }
}

