package com.pms.ocp.common.constants;

import java.io.UnsupportedEncodingException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class StringUtils {

	/**
	 * 常量3
	 */
	private static final int INT3 = 3;
	/**
	 * 常量4
	 */
	private static final int INT4 = 4;
	/**
	 * 常量16
	 */
	private static final int INT16 = 16;
	/**
	 * 常量0x4e00
	 */
	private static final int INT0X4E00 = 0x4e00;
	/**
	 * 常量0x9fa5
	 */
	private static final int INT0X9FA5 = 0x9fa5;
	/**
	 * 常量0xf900
	 */
	private static final int INT0XF900 = 0xf900;
	/**
	 * 常量0xfa2d
	 */
	private static final int INT0XFA2D = 0xfa2d;

	public static final String SLASH = getSlash();

    public static final String BACKSLASH = getBackslash();

    public static final String URL_SLASH = getURLSlash();

    public static final String BASE64_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    private static final int[] wi = {7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};

    private static final int[] vi = {1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2};

    private static int[] ai = new int[18];

    public StringUtils(){
    }
    
    /**
     * getSlash
     * @return 返回“/”
     */
    public static String getSlash()
    {
        return "/";
    }
    
    /**
     * @return 返回“\\”
     */
    public static String getBackslash()
    {
        return "\\";
    }
    
    /**
     * @return 返回“//”
     */
    public static String getURLSlash()
    {
        return "//";
    }
    
    /**
     * @return 返回网页的空符号“&nbsp;”
     */
    public static String getHTMLBlank()
    {
        return "&nbsp;";
    }
    
    /**
     * 判断两个字符串是否值相等
     * 
     * @param a
     *            设置第一个字符串
     * @param b
     *            设置第二个字符串
     * @return boolean 返回比较的结果
     */
    public static boolean compare(String a, String b) {
        if (isEmpty(a) && isEmpty(b))
            return true;
        if (!isEmpty(a) && !isEmpty(b))
            return a.equals(b);
        else
            return false;
    }
    
    /**
     * 判断两个字符串是否值相等，忽略大小写
     * @param a
     *            设置第一个字符串
     * @param b
     *            设置第二个字符串
     * @return boolean 返回比较的结果
     */
    public static boolean compareIgnoreCase(String a, String b)
    {
        if (isEmpty(a) && isEmpty(b))
            return true;
        if (!isEmpty(a) && !isEmpty(b))
            return a.equalsIgnoreCase(b);
        else
            return false;
    }
    
    /**
     * 复制字符串中从开始到指定的位置
     * 
     * @param src
     *            设置字符串
     * @param len
     *            指定复制到某个位置
     * @return String 返回结果
     */
    public static String copy(String src, int len)
    {
        if (src == null)
            return null;
        if (src.length() > len)
            return len <= 0 ? null : src.substring(0, len);
        else
            return src;
    }
    
    /**
     * 删除字符串中指定的一段字符串内容
     * 
     * @param src
     *            设置原字符串
     * @param delStr
     *            设置需要删除的字符串
     * @return String 返回结果
     */
    public static String delete(String src, String delStr)
    {
        if (isEmpty(src) || isEmpty(delStr))
            return src;
        StringBuffer buffer = new StringBuffer(src);
        for (int index = src.length(); (index = src.lastIndexOf(delStr, index)) >= 0; index -= delStr.length())
            buffer.delete(index, index + delStr.length());
        
        return buffer.toString();
    }
    
    /**
     * 将指定的字符和位置插入到原字符串中
     * 
     * @param src
     *            设置原字符串
     * @param anotherStr
     *            设置需要插入的字符串
     * @param offset
     *            位置
     * @return String 返回结果
     */
    public static String insert(String src, String anotherStr, int offset)
    {
        if (isEmpty(src) || isEmpty(anotherStr))
            return src;
        StringBuffer buffer = new StringBuffer(src);
        if (offset >= 0 && offset <= src.length())
            buffer.insert(offset, anotherStr);
        return buffer.toString();
    }
    
    /**
     * 追加指定的字符串到原字符串中
     * 
     * @param src
     *            设置原字符串
     * @param appendStr
     *            设置需要追加的字符串
     * @return String 返回结果
     */
    public static String append(String src, String appendStr)
    {
        if (isEmpty(src) || isEmpty(appendStr))
        {
            return src;
        }
        else
        {
            StringBuffer buffer = new StringBuffer(src);
            buffer.append(appendStr);
            return buffer.toString();
        }
    }
    
    /**
     * 根据参数替换字符串内容功能
     * 
     * @param src
     *            设置原字符串
     * @param oldStr
     *            指定替换字符串
     * @param newStr
     *            将要替换的内容
     * @param isCaseSensitive
     *            是否区分大小写
     * @return String 返回结果
     */
    public static String replace(String src, String oldStr, String newStr, boolean isCaseSensitive)
    {
        if (isEmpty(src) || isEmpty(oldStr) || newStr == null)
            return src;
        String s = isCaseSensitive ? src : src.toLowerCase();
        String o = isCaseSensitive ? oldStr : oldStr.toLowerCase();
        StringBuffer buffer = new StringBuffer(src);
        for (int index = s.length(); (index = s.lastIndexOf(o, index)) >= 0; index -= o.length())
            buffer.replace(index, index + o.length(), newStr);
        
        return buffer.toString();
    }
    
    /**
     * 根据参数替换字符串内容功能，可指定位置
     * 
     * @param src
     *            设置原字符串
     * @param oldStr
     *            指定替换字符串
     * @param newStr
     *            将要替换的内容
     * @param isCaseSensitive
     *            是否区分大小写
     * @param index
     *            指定位置
     * @return String 返回结果
     */
    public static String replace(String src, String oldStr, String newStr, boolean isCaseSensitive, int index)
    {
        if (src == null || src.length() == 0 || oldStr == null || oldStr.length() == 0 || index <= 0)
            return src;
        if (newStr == null)
            newStr = "";
        String s = isCaseSensitive ? src : src.toLowerCase();
        String o = isCaseSensitive ? oldStr : oldStr.toLowerCase();
        StringBuffer buffer = new StringBuffer(src);
        int length = o.length();
        int pos;
        for (pos = s.indexOf(o, 0); pos >= 0; pos = s.indexOf(o, pos + length))
            if (--index == 0)
                break;
        
        if (pos >= 0 && index == 0)
            buffer.replace(pos, pos + length, newStr);
        return buffer.toString();
    }
    
    /**
     * 获取指定符号分割的字符串数组
     * 
     * @param str
     *            设置原字符串
     * @param delimiter
     *            设置分割符号
     * @return String[] 返回字符串数组
     */
    public static String[] split(String str, String delimiter)
    {
        ArrayList array = new ArrayList();
        int index = 0;
        int begin = 0;
        String result[] = new String[0];
        if (isEmpty(str))
            return result;
        do
        {
            index = str.indexOf(delimiter, begin);
            if (index == begin)
            {
                if (index >= 0)
                    array.add("");
                begin += delimiter.length();
                continue;
            }
            if (index <= begin)
                break;
            int end = index;
            array.add(str.substring(begin, end));
            begin = index + delimiter.length();
        } while (true);
        if (begin >= 0 && begin < str.length())
            array.add(str.substring(begin));
        if (str.endsWith(delimiter))
            array.add("");
        if (array.size() > 0)
        {
            result = new String[array.size()];
            array.toArray(result);
        }
        return result;
    }
    
    /**
     * 获取指定符号分割的字符串数组，非空
     * 
     * @param str
     *            设置原字符串
     * @param delimiter
     *            设置分割符号
     * @return String[] 返回字符串数组
     */
    public static String[] splitWithoutEmpty(String str, String delimiter)
    {
        ArrayList array = new ArrayList();
        int index = 0;
        int begin = 0;
        String result[] = new String[0];
        if (isEmpty(str))
            return new String[0];
        do
        {
            index = str.indexOf(delimiter, begin);
            if (index == begin)
            {
                if (index > 0)
                    array.add("");
                begin += delimiter.length();
                continue;
            }
            if (index <= begin)
                break;
            int end = index;
            array.add(str.substring(begin, end));
            begin = index + delimiter.length();
        } while (true);
        if (begin >= 0 && begin < str.length())
            array.add(str.substring(begin));
        if (array.size() > 0)
        {
            result = new String[array.size()];
            array.toArray(result);
        }
        return result;
    }
    
    /**
     * 将指定字符串内容反转
     * 
     * @param str
     *            设置原字符串
     * @return String 返回字符串
     */
    public static String reverse(String str)
    {
        if (isEmpty(str))
        {
            return str;
        }
        else
        {
            StringBuffer buffer = new StringBuffer(str);
            buffer.reverse();
            return buffer.toString();
        }
    }
    
    /**
     * 给传入的字符串前后加双引号
     * 
     * @param str
     *            设置原字符串
     * @return String 返回结果
     */
    public static String quote(String str)
    {
        if (isEmpty(str))
            return "\"\"";
        StringBuffer buffer = new StringBuffer(str);
        if (!str.startsWith("\""))
            buffer.insert(0, "\"");
        if (!str.endsWith("\""))
            buffer.append("\"");
        return buffer.toString();
    }
    
    /**
     * 去除字符串中的双引号
     * 
     * @param str
     *            设置原字符串
     * @return String 返回结果
     */
    public static String extractQuotedStr(String str)
    {
        if (isEmpty(str))
            return str;
        StringBuffer buffer = new StringBuffer(str);
        int index = str.length();
        while (buffer.charAt(buffer.length() - 1) == '"')
        {
            buffer.deleteCharAt(buffer.length() - 1);
            index = buffer.length();
            if (index <= 0)
                break;
        }
        if (buffer.length() == 0)
            return "";
        while (buffer.charAt(0) == '"')
        {
            buffer.deleteCharAt(0);
            index = buffer.length();
            if (index <= 0)
                break;
        }
        return buffer.toString();
    }
    
    /**
     * 截取字符串中到指定的字符的内容，从左边开始
     * 
     * @param str
     *            设置原字符串
     * @param c
     *            设置指定字符
     * @return String 返回结果
     */
    public static String strChar(String str, char c)
    {
        if (str == null || str.length() == 0)
            return null;
        for (int i = 0; i < str.length(); i++)
            if (str.charAt(i) == c)
                return str.substring(i);
        
        return null;
    }
    
    /**
     * 截取字符串中到指定的字符的内容，从右边开始
     * 
     * @param str
     *            设置原字符串
     * @param c
     *            设置指定字符
     * @return String 返回结果
     */
    public static String strRChar(String str, char c)
    {
        if (str == null || str.length() == 0)
            return null;
        for (int i = str.length() - 1; i >= 0; i--)
            if (str.charAt(i) == c)
                return str.substring(i);
        
        return null;
    }
    
    /**
     * 将Object对象数组转成字符串数组
     * 
     * @param array
     *            设置Object对象数组
     * @return String[] 返回结果
     */
    public static String[] toArray(Object array[])
    {
        if (array == null || array.length == 0)
            return null;
        String result[] = new String[array.length];
        for (int i = 0; i < array.length; i++)
            if (array[i] != null)
                result[i] = array[i].toString();
        
        return result;
    }
    
    /**
     * 将Vector对象数组元素转成字符串数组
     * 
     * @param list
     *            设置Vector对象数组
     * @return String[] 返回结果
     */
    public static String[] toArray(Vector list)
    {
        if (list == null || list.size() == 0)
            return null;
        String result[] = new String[list.size()];
        for (int i = 0; i < list.size(); i++)
        {
            Object obj = list.get(i);
            if (obj != null)
                result[i] = list.get(i).toString();
        }
        
        return result;
    }
    
    /**
     * 将字符串数组复制到LIST中
     * 
     * @param array
     *            设置字符串数组
     * @param list
     *            设置LIST集合对象
     * @param index
     *            设置复制到LIST位置
     * @return List 返回结果
     */
    public static List copyToList(String array[], List list, int index)
    {
        if (array == null || array.length == 0)
            return list;
        if (list == null || index < 0)
            return list;
        for (int i = 0; i < array.length; i++)
            if (list.size() <= i + index)
                list.add(index + i, array[i]);
            else
                list.set(index + i, array[i]);
        
        return list;
    }
    
    /**
     * 判断字符串数组是否包含指定字符串
     * 
     * @param array
     *            设置字符串数组
     * @param str
     *            设置批量字符串
     * @return boolean 返回结果
     */
    public static boolean contains(Object array[], String str)
    {
        if (array == null || array.length == 0)
            return false;
        if (str == null)
            return false;
        for (int i = 0; i < array.length; i++)
        {
            Object obj = array[i];
            if (obj != null && str.equals(obj.toString()))
                return true;
        }
        
        return false;
    }
    
    /**
     * 获取字符串数组包含指定字符串的位置
     * 
     * @param array
     *            设置字符串数组
     * @param str
     *            设置批量字符串
     * @return int 返回结果
     */
    public static int indexOf(Object array[], String str)
    {
        if (array == null || array.length == 0)
            return -1;
        if (str == null)
            return -1;
        for (int i = 0; i < array.length; i++)
        {
            Object obj = array[i];
            if (obj != null && str.equals(obj.toString()))
                return i;
        }
        
        return -1;
    }
    
    /**
     * 验证是否为电子邮件格式
     * 
     * @param theEmail
     *            设置电子邮件地址字符串
     * @return boolean 返回是否合法
     */
    public static boolean isValidEmail(String theEmail)
    {
        boolean cbool = false;
        try
        {
            String check = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(theEmail);
            boolean isMatched = matcher.matches();
            if (isMatched)
            {
                cbool = true;
            }
            
        }
        catch (Exception e)
        {
            e.printStackTrace();
            return cbool;
        }
        return cbool;
    }
    
    /**
     * 去除字符串左边空格
     * 
     * @param str
     *            设置原字符串
     * @return String 返回结果
     */
    public static String trimLeft(String str)
    {
        if (str == null)
            return null;
        int length = str.length();
        if (length == 0)
            return "";
        StringBuffer buffer = new StringBuffer(str);
        int index;
        for (index = 0; index < length && buffer.charAt(index) == ' '; index++)
            ;
        if (index == length)
            return "";
        else
            return buffer.substring(index);
    }
    
    /**
     * 去除字符串右边空格
     * 
     * @param str
     *            设置原字符串
     * @return String 返回结果
     */
    public static String trimRight(String str)
    {
        if (str == null)
            return null;
        int length = str.length();
        if (length == 0)
            return "";
        StringBuffer buffer = new StringBuffer(str);
        int index;
        for (index = length - 1; index >= 0 && buffer.charAt(index) == ' '; index--)
            ;
        if (index < 0 && buffer.charAt(0) == ' ')
            return "";
        else
            return buffer.substring(0, index + 1);
    }
    
    /**
     * 去除字符串两边空格
     * 
     * @param str
     *            设置原字符串
     * @return String 返回结果
     */
    public static String trimAll(String str)
    {
        return str.trim();
    }
    
    /**
     * 去除字符串NULL
     * 
     * @param str
     *            设置原字符串
     * @return String 如果为NULL返回空字符串，否则返回原字符串,去除null字符串
     */
    public static String removeNull(String str)
    {
    	if(str == null){
    		return "";
    	}
        return str.replace("null", "");
    }
    
    /**
     * 去除对象NULL
     * 
     * @param str
     *            设置原字符串
     * @return String 如果为NULL返回空字符串，否则返回原字符串
     */
    public static String removeNull(Object str)
    {
        return str != null ? str.toString() : "";
    }
    
    /**
     * 实现判断字符串是否在数组中存在
     * 
     * @param strs
     *            设置字符串数组
     * @param str
     *            设置要查找的字符串
     * @param caseSensitive
     *            设置是否区分大小写
     * @return boolean 返回结果
     */
    public static boolean strInArray(String strs[], String str, boolean caseSensitive)
    {
        if (strs != null && strs.length > 0)
        {
            for (int i = 0; i < strs.length; i++)
            {
                if (caseSensitive)
                {
                    if (strs[i].equals(str))
                        return true;
                }
                else
                {
                    if (strs[i].equalsIgnoreCase(str))
                        return true;
                }
            }
        }
        
        return false;
    }
    
    /**
     * 验证身份证的合法性
     * 
     * @param idcard
     *            设置身份证字符串
     * @return boolean 返回结果
     */
    public static boolean idCardVerify(String idcard)
    {
        if (idcard.length() == 15)
        {
            idcard = idCardUptoeighteen(idcard);
        }
        if (idcard.length() != 18)
        {
            return false;
        }
        String verify = idcard.substring(17, 18);
        if (verify.equals(getIdCardVerify(idcard)))
        {
            return true;
        }
        return false;
    }
    
    /**
     * 获得身份证的合法性
     * 
     * @param eightcardid
     *            设置身份证字符串
     * @return String 返回结果
     */
    public static String getIdCardVerify(String eightcardid)
    {
        int remaining = 0;
        if (eightcardid.length() == 18)
        {
            eightcardid = eightcardid.substring(0, 17);
        }
        if (eightcardid.length() == 17)
        {
            int sum = 0;
            for (int i = 0; i < 17; i++)
            {
                String k = eightcardid.substring(i, i + 1);
                ai[i] = Integer.parseInt(k);
            }
            for (int i = 0; i < 17; i++)
            {
                sum = sum + wi[i] * ai[i];
            }
            remaining = sum % 11;
        }
        return remaining == 2 ? "X" : String.valueOf(vi[remaining]);
    }
    
    /**
     * 获得身份证15转18位
     * 
     * @param fifteencardid
     *            设置身份证字符串
     * @return String 返回结果
     */
    public static String idCardUptoeighteen(String fifteencardid)
    {
        if (fifteencardid.length() != 15)
            return null;
        String eightcardid = fifteencardid.substring(0, 6);
        eightcardid = eightcardid + "19";
        eightcardid = eightcardid + fifteencardid.substring(6, 15);
        eightcardid = eightcardid + getIdCardVerify(eightcardid);
        return eightcardid;
    }
    
    /**
     * 验证电话号码合法格式，格式为02584555112
     * 
     * @param phoneCode
     *            设置电话号码字符串
     * @return boolean 返回结果
     */
    public static boolean isPhoneNum(String phoneCode)
    {
        Pattern p = Pattern.compile("[0][1-9]{2,3}[1-9]{6,8}");
        Matcher m = p.matcher(phoneCode);
        boolean b = m.matches();
        return b;
    }
    
    /**
     * 验证手机号码合法格式，格式为13984555112
     * 
     * @param phoneCode
     *            设置手机号码字符串
     * @return boolean 返回结果
     */
    public static boolean isMobilePhoneNum(String phoneCode)
    {
        Pattern p = Pattern.compile("^0{0,1}(13[0-9]|15[0-9]|18[0-9])[0-9]{8}");
        Matcher m = p.matcher(phoneCode);
        boolean b = m.matches();
        return b;
    }
    
    /**
     * 字符数组转换为字符串,用逗号隔开
     * 
     * @param str
     * @return String
     */
    public static String arrayToString(final String[] str)
    {
        if (str == null)
            return "";
        StringBuffer rStr = new StringBuffer("");
        for (int i = 0; i < str.length; i++)
        {
            rStr.append(str[i]);
            rStr.append(",");
        }
        // 截取逗号
        if (rStr.toString().length() > 0)
        {
            rStr.setLength(rStr.length() - 1);
        }
        return rStr.toString();
    }
    
    /**
     * 字符数组转换为字符串,用逗号隔开
     * 
     * @param str
     * @param beginIndex
     * @param length
     * @return  String
     */
    public static String arrayToString(final String[] str, int beginIndex, int length)
    {
        if (str == null || beginIndex > str.length - 1)
            return "";
        StringBuffer rStr = new StringBuffer("");
        
        int condition = beginIndex + length - 1;
        
        if(condition > str.length - 1)
        {
        	condition =  str.length - 1;
        }
        rStr.append("'");
        for (int i = beginIndex; i < condition; i++)
        {
        	rStr.append(str[i]).append("','");
        }
        rStr.append(str[condition]).append("'");

        return rStr.toString();
    }
    
    /**
     * 字符数组转换为字符串,用逗号隔开
     * 
     * @param str
     * @param beginIndex
     * @param length
     * @return String
     */
    public static String arrayToIntegerString(final String[] str, int beginIndex, int length)
    {
        if (str == null || beginIndex > str.length - 1)
        {
            return "";
        }
        
        StringBuffer rStr = new StringBuffer("");
        
        int condition = beginIndex + length - 1;
        
        if(condition > str.length - 1)
        {
        	condition =  str.length - 1;
        }
        
        for (int i = beginIndex; i < condition; i++)
        {
            rStr.append(str[i]);
            rStr.append(",");
        }
        rStr.append(str[condition]);

        return rStr.toString();
    }
    /**
     * 判定一个对象是否为null or empty
     * 
     * @param o
     *            对象
     * @return true or false
     */
    public static boolean isNullOrEmpty(Object o) {
	return o == null || String.valueOf(o).trim().length() == 0
		|| "null".equals(String.valueOf(o).trim());
    }

    /**
     * 根据分隔符将字符串分开，并加上"'"输出(12,23,234 to '12','23','234')
     * 
     * @param s
     * @param spiltter
     *            分隔符
     * @return String
     */
    public static String formatString(String s, String spiltter)
    {
        if (StringUtils.isEmpty(s))
            return "";
        StringBuffer result = new StringBuffer();
        String[] temp = s.split(spiltter);
        for (String str : temp)
        {
            if (str.trim().length() > 0)
                result.append(spiltter).append("'").append(str).append("'");
        }
        
        return result.length() > 0 ? result.substring(1) : result.toString();
    }
    
    /**
     * 格式化字符串(12,23,234 to '12','23','234')
     * 
     * @param s
     * @return String
     */
    public static String formatString(String s)
    {
        return formatString(s, ",");
    }
    
    /**
     * 生成messageID
     * 
     * @return String
     */
    public static String createMessageId()
    {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTimeInMillis() + "";
    }
    
    /**
     * 判断集合Collection是否为空
     * @param collection
     * @return boolean
     */
    public static boolean isNullOrEmpty(Collection collection) {
	return collection == null || collection.size() == 0;
    }
    
    /**
     * 格式化Object
     * @param o
     * @return String
     */
    public static String valueOf(Object o) {
	return StringUtils.isNullOrEmpty(o) ? "" : o.toString();
    }

    /**
     * valueOf
     * @param o
     * @param changevalue
     * @return String
     */
    public static String valueOf(Object o,String changevalue)
    {
	return StringUtils.isNullOrEmpty(o) ?changevalue:o.toString();
    }
    
    /**
	 * 判断一个字符串是否有值，空格也不算有值
	 * @param str 
	 * @return boolean
	 */
	public static boolean availableStr(String str){
		if(str!=null && !"".equals(str) && !"null".equals(str)){
			String avaStr = str.trim();
			return (avaStr!=null && !"".equals(avaStr) && !"null".equals(avaStr));
		}else{
			return false;
		}
	}
	
	/**
     * 截取子字符串
     * @param str 需要截取的字符串
     * @param len 截取的位数
     * @return String 返回的子字符串
     */
    public static String getSubString(String str, int len) {
        if (isEmpty(str)) {
            return "";
        }
        if (0 >= len) {
            return str;
        }
        final int byteLength = getByteLength(str);

        if (byteLength < len) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        sb.setLength(len);

        while (getByteLength(sb.toString()) > len) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    /**
     * 得到字节长度
     * @param str 需要得到长度的字符串
     * @return 返回字节的长度
     */
    public static int getByteLength(String str) {
        int len = 0;
        if (isEmpty(str)) {
            return len;
        }
        try {
			len = str.getBytes("UTF-8").length;
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
        return len;
    }
    
    /**
     * 判断字符串是否为空
     * @param obj 字符串
     * @return true：空 false：非空
     */
    public static boolean isEmpty(Object obj) {
    	String str = obj + "";
        if (null == str || 0 == str.length()||"null".equals(str)||"".equals(str)) {
            return true;
        }
        return false;
    }

	/**
	 * 把字符串中的双引号和反斜杠替换为画面能够识别的字符串
	 * @param inStr 
	 * @return outStr
	 */
	public static String escapeSpecialChar(String inStr){
		if (null == inStr || "null".equals(inStr) || "".equals(inStr)) {
			return "";
		}
		String outStr = "";
		//替换双引号
		String srcStr1 = "\"";	
		String destStr1 = "\\\\\"";  
		//替换反斜杠
		String srcStr2 = "\\\\";
		String destStr2 = "\\\\\\\\";
		outStr = inStr.replaceAll(srcStr2, destStr2);
		outStr = outStr.replaceAll(srcStr1, destStr1);
		return outStr;
		
	}
	
	/**
	 * 将String中的xml格式的Excel的关键字转义
	 * @param str 
	 * @return String
	 */
	public static String encodeExcelXmlStr(String str){
		if(isEmpty(str)){
			return str;
		}
		return str.replaceAll("&", "&amp;")
				.replaceAll("<", "&lt;")
				.replaceAll(">", "&gt;")
				.replaceAll("\"","&quot;" )
				.replaceAll("\r\n","&#10;")
				.replaceAll("\n","&#10;");
	}
	
	
	/**
	 *判断输入字符串是否为整型数据 
	 * @param str	字符串
	 * @return	boolean
	 */
	public static boolean isInteger(String str) {
		if(availableStr(str)) {
			try {
				Integer.parseInt(str);
				return true;
			}catch(NumberFormatException e) {
				return false;
			}
		}
		return false;
	}
	
	/**
	 *判断输入字符串是否为长整型数据 
	 * @param str	字符串
	 * @return	boolean
	 */
	public static boolean isLong(String str) {
		if(availableStr(str)) {
			try {
				Long.parseLong(str);
				return true;
			}catch(NumberFormatException e) {
				return false;
			}
		}
		return false;
	}
	
	/**
	 *判断输入字符串是否为单精度浮点型数据
	 * @param str	字符串
	 * @return	boolean
	 */
	public static boolean isFloat(String str) {
		if(availableStr(str)) {
			try {
				Float.parseFloat(str);
				return true;
			}catch(NumberFormatException e) {
				return false;
			}
		}
		return false;
	}
	
	
	/**
	 * 判断字符是否为汉字（汉字标点不为汉字字符）
	 * @param oneChar 
	 * @return boolean
	 */
	public static boolean isChineseWithoutPunctuation(char oneChar){
		if((oneChar >= INT0X4E00 && oneChar <= INT0X9FA5)
		 ||(oneChar >= INT0XF900 && oneChar <=INT0XFA2D)){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断字符是否为汉字（汉字标点为汉字字符）
	 * @param oneChar 
	 * @return boolean
	 */
	public static boolean isChineseWithPunctuation(char oneChar) {
    	Character.UnicodeBlock ub = Character.UnicodeBlock.of(oneChar);
    	if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS 
    	 || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS 
    	 || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A 
    	 || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B 
    	 || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION 
    	 || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS 
    	 || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
             return true; 
         } 
         return false; 
     } 

	
	/**
	 * 把ip地址格式化为：000.000.000.000
	 * @param ip 
	 * @return 返回规格ip
	 */
	public static String strfullip(String ip){
		StringBuffer buff = new StringBuffer();
		buff.append("");
		String strzero = "000";
		int ilen = 0;
		if(ip != null){
			String[] arrip = ip.split("\\.");
			if(arrip.length == INT4){
				for(int i = 0; i < INT4; i++){
					if (i==0){
						ilen = arrip[i].length();
						if(ilen < INT3){
							buff.append(strzero.substring(0,INT3-ilen)).append(arrip[i]);
						}else{
							buff.append(arrip[i]);
						}
					}else{
						ilen = arrip[i].length();
						if(ilen < INT3){
							buff.append(".").append(strzero.substring(0,INT3-ilen)).append(arrip[i]);
						}else{
							buff.append(".").append(arrip[i]);
						}
					}
				}
			}
		}
		return buff.toString();
	}
	
    /**
     * 根据传入的字符串和编码取得对应的编码的字符串，主要用于前后台参数传递场景，防止出现乱码
     * @param str 
     * @param charSet 
     * @return String
     */
	public static String getStringByCharset(String str, String charSet){
		if (isEmpty(str)||isEmpty(charSet)) {
			return null;
        }
		try {
			return  String.valueOf(str.getBytes(charSet));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * 根据源字符串和编码取得字符串，并获取处理后的字符串长度
	 * @param str 
	 * @param charSet 
	 * @return int
	 */
	public  static int getStringByLength(String str, String charSet){
		str = getStringByCharset(str,charSet);
		if(availableStr(str)){
			return str.length();
		}else{
			return 0;
		}
	}
	
	/**
	 * 将容易引起xss漏洞的半角字符直接替换成全角字符
	 * @param s	原始字符串
	 * @return	替换危险字符之后的字符串
	 */
	public static String xssEncode(String s) {
		if (s == null || "".equals(s)) {
			return s;
		}
		StringBuilder sb = new StringBuilder(s.length() + INT16);
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			switch (c) {
			case '>':
				sb.append('＞');// 全角大于号
				break;
			case '<':
				sb.append('＜');// 全角小于号
				break;
//			case '\'':
//				sb.append('‘');// 全角单引号
//				break;
//			case '\"':
//				sb.append('“');// 全角双引号
//				break;
//			case '&':
//				sb.append('＆');// 全角
//				break;
//			case '%':
//				sb.append('％');// 全角
//				break;
			case '+':
				sb.append("＋");// 全角
				break;	
			case ';':
				sb.append("；");// 全角
				break;	
			case '\\':
				sb.append('＼');// 全角斜线
				break;
//			case '/':
//				sb.append('／');// 全角斜线
//				break;
			case '#':
				sb.append('＃');// 全角井号
				break;
//			case ':':
//				sb.append('：');// 全角冒号
//				break;
			default:
				sb.append(c);
				break;
			}
		}
		return sb.toString();
	}

    /**
     * 判断是否有中文字符并转换为英文
     * @param s 入参
     * @return String 处理后的参数
     */
    public static  String conversionCharacter(String s){
        final String REG_EX = "[ _`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~！@#￥%……&*（）——+|{}【】‘；：”“’。，、？]|\n|\r|\t";
        Pattern p = Pattern.compile(REG_EX);
        Matcher m = p.matcher(s);
        boolean b = m.find();
        if (b){
         s=toSemiangle(s) ;
        }
        return s.replaceAll("\\s*","");
    }

    /**
     * 全角转半角
     * @param src
     * @return String
     */
    public static String toSemiangle(String src) {
        char[] c = src.toCharArray();
        for (int index = 0; index < c.length; index++) {
            // 全角空格
            if (c[index] == 12288) {
                c[index] = (char) 32;
                // 其他全角字符
            } else if (c[index] > 65280 && c[index] < 65375) {
                c[index] = (char) (c[index] - 65248);
            }
        }
        return String.valueOf(c).intern();
    }
    /**
     * 获取uuid
     * @return string
     * */
    public static String getUUid()
    {
        return UUID.randomUUID().toString().replaceAll("-","");
    }
}
