package com.pms.ocp.model.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 应用扩展信息表
 * @TableName ocp_tenant_extent
 */
@Data
@Accessors(chain = true)
@TableName("ocp_tenant_extent")
@ApiModel("应用扩展信息表1")
public class OcpTenantExtent implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty("主键ID")
    private String objId;

    /**
     * 服务编码
     */
    @ApiModelProperty("服务编码")
    private String tenantCode;

    /**
     * 部署公司
     */
    @ApiModelProperty("部署公司")
    private String depCompanyCode;

    /**
     * 是否已删除
     */
    @ApiModelProperty("是否已删除")
    private Short isDelete;

    /**
     * 集群名称
     */
    @ApiModelProperty("集群名称")
    private String clusterName;

    /**
     * 命名空间
     */
    @ApiModelProperty("命名空间")
    private String spaceName;

    /**
     * db大小
     */
    @ApiModelProperty("db大小")
    private String dbSize;

    /**
     * 部署名称
     */
    @ApiModelProperty("部署名称")
    private String deploymentName;

    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String tenantDescription;

    /**
     * 应用状态 0:已发布 1:未发布
     */
    @ApiModelProperty("应用状态 0:已发布 1:未发布 2:已下线")
    private Short tenantState;

    /**
     * 添加时间
     */
    @ApiModelProperty("添加时间")
    private Date tenantCtime;

    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date tenantMtime;

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    public String getObjId() {
        return objId;
    }

    /**
     * 主键
     */
    public void setObjId(String objId) {
        this.objId = objId;
    }

    /**
     * 服务编码
     */
    public String getTenantCode() {
        return tenantCode;
    }

    /**
     * 服务编码
     */
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    /**
     * 部署公司
     */
    public String getDepCompanyCode() {
        return depCompanyCode;
    }

    /**
     * 部署公司
     */
    public void setDepCompanyCode(String depCompanyCode) {
        this.depCompanyCode = depCompanyCode;
    }

    /**
     * 是否已删除
     */
    public Short getIsDelete() {
        return isDelete;
    }

    /**
     * 是否已删除
     */
    public void setIsDelete(Short isDelete) {
        this.isDelete = isDelete;
    }

    /**
     * 集群名称
     */
    public String getClusterName() {
        return clusterName;
    }

    /**
     * 集群名称
     */
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    /**
     * 命名空间
     */
    public String getSpaceName() {
        return spaceName;
    }

    /**
     * 命名空间
     */
    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    /**
     * db大小
     */
    public String getDbSize() {
        return dbSize;
    }

    /**
     * db大小
     */
    public void setDbSize(String dbSize) {
        this.dbSize = dbSize;
    }

    /**
     * 部署名称
     */
    public String getDeploymentName() {
        return deploymentName;
    }

    /**
     * 部署名称
     */
    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    /**
     * 描述
     */
    public String getTenantDescription() {
        return tenantDescription;
    }

    /**
     * 描述
     */
    public void setTenantDescription(String tenantDescription) {
        this.tenantDescription = tenantDescription;
    }

    /**
     * 应用状态 0:已发布 1:未发布
     */
    public Short getTenantState() {
        return tenantState;
    }

    /**
     * 应用状态 0:已发布 1:未发布
     */
    public void setTenantState(Short tenantState) {
        this.tenantState = tenantState;
    }

    /**
     * 添加时间
     */
    public Date getTenantCtime() {
        return tenantCtime;
    }

    /**
     * 添加时间
     */
    public void setTenantCtime(Date tenantCtime) {
        this.tenantCtime = tenantCtime;
    }

    /**
     * 修改时间
     */
    public Date getTenantMtime() {
        return tenantMtime;
    }

    /**
     * 修改时间
     */
    public void setTenantMtime(Date tenantMtime) {
        this.tenantMtime = tenantMtime;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        OcpTenantExtent other = (OcpTenantExtent) that;
        return (this.getObjId() == null ? other.getObjId() == null : this.getObjId().equals(other.getObjId()))
            && (this.getTenantCode() == null ? other.getTenantCode() == null : this.getTenantCode().equals(other.getTenantCode()))
            && (this.getDepCompanyCode() == null ? other.getDepCompanyCode() == null : this.getDepCompanyCode().equals(other.getDepCompanyCode()))
            && (this.getIsDelete() == null ? other.getIsDelete() == null : this.getIsDelete().equals(other.getIsDelete()))
            && (this.getClusterName() == null ? other.getClusterName() == null : this.getClusterName().equals(other.getClusterName()))
            && (this.getSpaceName() == null ? other.getSpaceName() == null : this.getSpaceName().equals(other.getSpaceName()))
            && (this.getDbSize() == null ? other.getDbSize() == null : this.getDbSize().equals(other.getDbSize()))
            && (this.getDeploymentName() == null ? other.getDeploymentName() == null : this.getDeploymentName().equals(other.getDeploymentName()))
            && (this.getTenantDescription() == null ? other.getTenantDescription() == null : this.getTenantDescription().equals(other.getTenantDescription()))
            && (this.getTenantState() == null ? other.getTenantState() == null : this.getTenantState().equals(other.getTenantState()))
            && (this.getTenantCtime() == null ? other.getTenantCtime() == null : this.getTenantCtime().equals(other.getTenantCtime()))
            && (this.getTenantMtime() == null ? other.getTenantMtime() == null : this.getTenantMtime().equals(other.getTenantMtime()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getObjId() == null) ? 0 : getObjId().hashCode());
        result = prime * result + ((getTenantCode() == null) ? 0 : getTenantCode().hashCode());
        result = prime * result + ((getDepCompanyCode() == null) ? 0 : getDepCompanyCode().hashCode());
        result = prime * result + ((getIsDelete() == null) ? 0 : getIsDelete().hashCode());
        result = prime * result + ((getClusterName() == null) ? 0 : getClusterName().hashCode());
        result = prime * result + ((getSpaceName() == null) ? 0 : getSpaceName().hashCode());
        result = prime * result + ((getDbSize() == null) ? 0 : getDbSize().hashCode());
        result = prime * result + ((getDeploymentName() == null) ? 0 : getDeploymentName().hashCode());
        result = prime * result + ((getTenantDescription() == null) ? 0 : getTenantDescription().hashCode());
        result = prime * result + ((getTenantState() == null) ? 0 : getTenantState().hashCode());
        result = prime * result + ((getTenantCtime() == null) ? 0 : getTenantCtime().hashCode());
        result = prime * result + ((getTenantMtime() == null) ? 0 : getTenantMtime().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", objId=").append(objId);
        sb.append(", tenantCode=").append(tenantCode);
        sb.append(", depCompanyCode=").append(depCompanyCode);
        sb.append(", isDelete=").append(isDelete);
        sb.append(", clusterName=").append(clusterName);
        sb.append(", spaceName=").append(spaceName);
        sb.append(", dbSize=").append(dbSize);
        sb.append(", deploymentName=").append(deploymentName);
        sb.append(", tenantDescription=").append(tenantDescription);
        sb.append(", tenantState=").append(tenantState);
        sb.append(", tenantCtime=").append(tenantCtime);
        sb.append(", tenantMtime=").append(tenantMtime);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}