package com.pms.ocp.model.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDateTime;

@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "服务列表信息vo")
public class OcpApiBaseVo implements Serializable {
    @ApiModelProperty(value = "序号")
    @Excel(name = "序号")
    private String objId;
    @ApiModelProperty(value = "服务编码")
    @Excel(name = "服务编码")
    private String apiCode;
    @ApiModelProperty(value = "服务中文名称")
    @Excel(name = "服务中文名称")
    private String apiName;
    @ApiModelProperty(value = "所属集群")
    @Excel(name = "所属集群")
    private String clusterName;
    @ApiModelProperty(value = "所属命名空间")
    @Excel(name = "所属命名空间")
    private String spaceName;
    @ApiModelProperty(value = "接口URL")
    @Excel(name = "接口URL")
    private String apiUrl;
    @ApiModelProperty(value = "状态")
    @Excel(name = "状态")
    private String apiState;
    @ApiModelProperty(value = "注册时间")
    @Excel(name = "注册时间")
    private Timestamp apiCtime;
    @ApiModelProperty(value = "建设单位")
    @Excel(name = "建设单位")
    private String apiUnit;

}

